/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Endpoint;
import org.apache.log4j.Logger;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceReference;
import org.switchyard.common.type.Classes;
import org.switchyard.component.soap.BaseWebService;
import org.switchyard.component.soap.DefaultMessageComposer;
import org.switchyard.component.soap.DefaultMessageDecomposer;
import org.switchyard.component.soap.MessageComposer;
import org.switchyard.component.soap.MessageDecomposer;
import org.switchyard.component.soap.PortName;
import org.switchyard.component.soap.WebServicePublishException;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.util.SOAPUtil;
import org.switchyard.component.soap.util.WSDLUtil;
import org.switchyard.metadata.BaseExchangeContract;
import org.switchyard.metadata.ExchangeContract;

public class InboundHandler
extends BaseHandler {
    private static final Logger LOGGER = Logger.getLogger(InboundHandler.class);
    private static final long DEFAULT_TIMEOUT = 15000L;
    private static final int DEFAULT_SLEEP = 100;
    private static final String MESSAGE_NAME = "MESSAGE_NAME";
    private static final String WSDL_LOCATION = "javax.xml.ws.wsdl.description";
    private final ConcurrentHashMap<String, BaseExchangeContract> _contracts = new ConcurrentHashMap();
    private static ThreadLocal<SOAPMessage> _response = new ThreadLocal();
    private MessageComposer _composer;
    private MessageDecomposer _decomposer;
    private ServiceReference _service;
    private long _waitTimeout = 15000L;
    private Endpoint _endpoint;
    private Port _wsdlPort;
    private String _scheme = "http";
    private SOAPBindingModel _config;

    public InboundHandler(SOAPBindingModel config) {
        this._config = config;
        String composer = config.getComposer();
        String decomposer = config.getDecomposer();
        if (composer != null && composer.length() > 0) {
            try {
                Class<MessageComposer> composerClass = Classes.forName((String)composer, ((Object)((Object)this)).getClass()).asSubclass(MessageComposer.class);
                this._composer = composerClass.newInstance();
            }
            catch (Exception cnfe) {
                LOGGER.error((Object)"Could not instantiate composer", (Throwable)cnfe);
            }
        }
        if (this._composer == null) {
            this._composer = new DefaultMessageComposer();
        }
        if (decomposer != null && decomposer.length() > 0) {
            try {
                Class<MessageDecomposer> decomposerClass = Classes.forName((String)decomposer, ((Object)((Object)this)).getClass()).asSubclass(MessageDecomposer.class);
                this._decomposer = decomposerClass.newInstance();
            }
            catch (Exception cnfe) {
                LOGGER.error((Object)"Could not instantiate decomposer", (Throwable)cnfe);
            }
        }
        if (this._decomposer == null) {
            this._decomposer = new DefaultMessageDecomposer();
        }
    }

    public void start(ServiceReference service) throws WebServicePublishException {
        try {
            this._service = service;
            PortName portName = this._config.getPort();
            Service wsdlService = WSDLUtil.getService(this._config.getWsdl(), portName);
            this._wsdlPort = WSDLUtil.getPort(wsdlService, portName);
            portName.setServiceQName(wsdlService.getQName());
            portName.setName(this._wsdlPort.getName());
            BaseWebService wsProvider = new BaseWebService();
            wsProvider.setInvocationClassLoader(Thread.currentThread().getContextClassLoader());
            wsProvider.setConsumer(this);
            this._contracts.putAll(WSDLUtil.getContracts(this._wsdlPort, service));
            this._endpoint = Endpoint.create((Object)wsProvider);
            ArrayList<StreamSource> metadata = new ArrayList<StreamSource>();
            StreamSource source = WSDLUtil.getStream(this._config.getWsdl());
            metadata.add(source);
            this._endpoint.setMetadata(metadata);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("javax.xml.ws.wsdl.service", portName.getServiceQName());
            properties.put("javax.xml.ws.wsdl.port", portName.getPortQName());
            properties.put(WSDL_LOCATION, this._config.getWsdl());
            this._endpoint.setProperties(properties);
            String path = "/" + portName.getServiceName();
            if (this._config.getContextPath() != null) {
                path = "/" + this._config.getContextPath() + "/" + portName.getServiceName();
            }
            String publishUrl = this._scheme + "://" + this._config.getServerHost() + ":" + this._config.getServerPort() + path;
            this._endpoint.publish(publishUrl);
            LOGGER.info((Object)("WebService published at " + publishUrl));
        }
        catch (WSDLException e) {
            throw new WebServicePublishException(e);
        }
    }

    public void stop() {
        this._endpoint.stop();
        LOGGER.info((Object)("WebService " + this._config.getPort() + " stopped."));
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        try {
            _response.set(this._decomposer.decompose(exchange.getMessage()));
        }
        catch (SOAPException se) {
            throw new HandlerException("Unexpected exception generating SOAP Message", (Throwable)se);
        }
    }

    public void handleFault(Exchange exchange) {
        try {
            _response.set(this._decomposer.decompose(exchange.getMessage()));
        }
        catch (SOAPException se) {
            try {
                _response.set(SOAPUtil.generateFault(se));
            }
            catch (SOAPException e) {
                LOGGER.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPMessage invoke(SOAPMessage soapMessage) {
        BaseExchangeContract exchangeContract;
        Operation operation;
        String operationName;
        Boolean oneWay = false;
        _response.remove();
        try {
            operationName = SOAPUtil.getOperationName(soapMessage);
            operation = WSDLUtil.getOperation(this._wsdlPort, operationName);
            oneWay = WSDLUtil.isOneWay(operation);
            exchangeContract = this._contracts.get(operationName);
        }
        catch (SOAPException e) {
            LOGGER.error((Object)e);
            return null;
        }
        if (exchangeContract == null) {
            this.handleException(oneWay, new SOAPException("Operation '" + operationName + "' not available on target Service '" + this._service.getName() + "'."));
            return _response.get();
        }
        try {
            Exchange exchange = this._service.createExchange((ExchangeContract)exchangeContract, (ExchangeHandler)this);
            Message message = this._composer.compose(soapMessage, exchange);
            if (!this.assertComposedMessageOK(message, operation, oneWay)) {
                SOAPMessage sOAPMessage = _response.get();
                return sOAPMessage;
            }
            exchange.getContext().setProperty(MESSAGE_NAME, (Object)operation.getInput().getMessage().getQName().getLocalPart(), Scope.IN);
            if (oneWay.booleanValue()) {
                exchange.send(message);
            } else {
                exchange.send(message);
                this.waitForResponse();
            }
            SOAPMessage sOAPMessage = _response.get();
            return sOAPMessage;
        }
        catch (SOAPException se) {
            this.handleException(oneWay, se);
        }
        finally {
            _response.remove();
        }
        return null;
    }

    private boolean assertComposedMessageOK(Message soapMessage, Operation operation, Boolean oneWay) {
        Object content = soapMessage.getContent();
        if (content == null) {
            this.handleException(oneWay, new SOAPException("Composer created a null ESB Message payload for service '" + this._service.getName() + "'.  Must be of type '" + SOAPMessage.class.getName() + "'."));
            return false;
        }
        if (!(content instanceof Node)) {
            this.handleException(oneWay, new SOAPException("Composer created invalid ESB Message payload type '" + content.getClass().getName() + "' for service '" + this._service.getName() + "'.  Must be of type '" + Node.class.getName() + "'."));
            return false;
        }
        Node inputMessage = (Node)content;
        QName expectedPayloadType = operation.getInput().getMessage().getQName();
        String expectedNS = expectedPayloadType.getNamespaceURI();
        String expectedLN = expectedPayloadType.getLocalPart();
        String actualNS = inputMessage.getNamespaceURI();
        String actualLN = inputMessage.getLocalName();
        if (expectedNS != null && !expectedNS.equals(actualNS)) {
            this.handleException(oneWay, new SOAPException("Invalid input SOAP payload namespace for service operation '" + operation.getName() + "' (service '" + this._service.getName() + "').  Port defines operation namespace as '" + expectedNS + "'.  Actual namespace on input SOAP message '" + actualNS + "'."));
            return false;
        }
        if (expectedLN != null && !expectedLN.equals(actualLN)) {
            this.handleException(oneWay, new SOAPException("Invalid input SOAP payload localNamePart for service operation '" + operation.getName() + "' (service '" + this._service.getName() + "').  Port defines operation localNamePart as '" + expectedLN + "'.  Actual localNamePart on input SOAP message '" + actualLN + "'."));
            return false;
        }
        return true;
    }

    private void handleException(Boolean oneWay, SOAPException se) {
        if (oneWay.booleanValue()) {
            LOGGER.error((Object)se);
        } else {
            try {
                _response.set(SOAPUtil.generateFault(se));
            }
            catch (SOAPException e) {
                LOGGER.error((Object)e);
            }
        }
    }

    private void waitForResponse() {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + this._waitTimeout) {
            if (_response.get() != null) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
    }
}

