/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import org.apache.log4j.Logger;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.component.soap.InboundHandler;
import org.switchyard.component.soap.OutboundHandler;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.exception.SwitchYardException;

public class SOAPGateway {
    private static final Logger LOGGER = Logger.getLogger(SOAPGateway.class);
    private InboundHandler _wsProvider;
    private OutboundHandler _wsConsumer;
    private SOAPBindingModel _config;
    private ServiceDomain _domain;

    public void init(SOAPBindingModel config, ServiceDomain domain) {
        this._domain = domain;
        this._config = config;
        if (config.getPublishAsWS().booleanValue()) {
            this._wsProvider = new InboundHandler(config);
        } else {
            this._wsConsumer = new OutboundHandler(config);
            this._domain.registerService(config.getServiceName(), (ExchangeHandler)this._wsConsumer);
        }
    }

    public void start() {
        if (this._wsProvider != null) {
            try {
                this._wsProvider.start(this._domain.getService(this._config.getServiceName()));
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
                throw new SwitchYardException("WebService could not be published!");
            }
        }
        if (this._wsConsumer != null) {
            try {
                this._wsConsumer.start();
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
                throw new SwitchYardException("WebService could not be consumed!");
            }
        }
    }

    public void stop() {
        if (this._wsProvider != null) {
            this._wsProvider.stop();
        }
        if (this._wsConsumer != null) {
            this._wsConsumer.stop();
        }
    }

    public void destroy() {
    }
}

