/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.config.model;

import javax.xml.namespace.QName;
import org.switchyard.component.soap.PortName;
import org.switchyard.component.soap.config.model.ValueModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.v1.V1BindingModel;

public class SOAPBindingModel
extends V1BindingModel {
    public static final String SOAP = "soap";
    public static final String DEFAULT_NAMESPACE = "urn:switchyard-component-soap:config:1.0";
    private static final String WSDL = "wsdl";
    private static final String PORT = "port";
    private static final String SERVER_HOST = "serverHost";
    private static final String SERVER_PORT = "serverPort";
    private static final String COMPOSER = "composer";
    private static final String DECOMPOSER = "decomposer";
    private static final int DEFAULT_PORT = 8080;
    private PortName _port;
    private String _wsdl;
    private QName _serviceName;
    private String _serverHost;
    private int _serverPort = -1;
    private String _contextPath;
    private String _composer;
    private String _decomposer;
    private Boolean _publishAsWS = false;

    public SOAPBindingModel() {
        super(SOAP, DEFAULT_NAMESPACE);
        this.setModelChildrenOrder(new String[]{WSDL, PORT, SERVER_HOST, SERVER_PORT, COMPOSER, DECOMPOSER});
    }

    public SOAPBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    public PortName getPort() {
        if (this._port == null) {
            Configuration childConfig = this.getModelConfiguration().getFirstChild(PORT);
            this._port = childConfig != null ? new PortName(childConfig.getValue()) : new PortName();
        }
        return this._port;
    }

    public void setPort(PortName port) {
        this._port = port;
    }

    public String getWsdl() {
        Configuration childConfig;
        if (this._wsdl == null && (childConfig = this.getModelConfiguration().getFirstChild(WSDL)) != null) {
            this._wsdl = childConfig.getValue();
        }
        return this._wsdl;
    }

    public void setWsdl(String wsdl) {
        this._wsdl = wsdl;
        Configuration childConfig = this.getModelConfiguration().getFirstChild(WSDL);
        if (childConfig == null) {
            ValueModel portConfig = new ValueModel(WSDL);
            portConfig.setValue(wsdl);
            this.setChildModel((Model)portConfig);
        } else {
            childConfig.setValue(wsdl);
        }
    }

    public QName getServiceName() {
        if (this._serviceName == null) {
            this._serviceName = this.getService().getQName();
        }
        return this._serviceName;
    }

    public void setServiceName(QName serviceName) {
        this._serviceName = serviceName;
    }

    public String getServerHost() {
        if (this._serverHost == null) {
            Configuration childConfig = this.getModelConfiguration().getFirstChild(SERVER_HOST);
            this._serverHost = childConfig == null ? "localhost" : childConfig.getValue();
        }
        return this._serverHost;
    }

    public void setServerHost(String serverhost) {
        this._serverHost = serverhost;
    }

    public int getServerPort() {
        if (this._serverPort == -1) {
            Configuration childConfig = this.getModelConfiguration().getFirstChild(SERVER_PORT);
            this._serverPort = childConfig == null ? 8080 : Integer.parseInt(childConfig.getValue());
        }
        return this._serverPort;
    }

    public void setServerPort(int serverPort) {
        this._serverPort = serverPort;
        Configuration childConfig = this.getModelConfiguration().getFirstChild(SERVER_PORT);
        if (childConfig == null) {
            ValueModel portConfig = new ValueModel(SERVER_PORT);
            portConfig.setValue(String.valueOf(serverPort));
            this.setChildModel((Model)portConfig);
        } else {
            childConfig.setValue(String.valueOf(serverPort));
        }
    }

    public String getContextPath() {
        Configuration childConfig;
        if (this._contextPath == null && (childConfig = this.getModelConfiguration().getFirstChild("contextPath")) != null) {
            this._contextPath = childConfig.getValue();
        }
        return this._contextPath;
    }

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public String getComposer() {
        Configuration childConfig;
        if (this._composer == null && (childConfig = this.getModelConfiguration().getFirstChild(COMPOSER)) != null) {
            this._composer = childConfig.getValue();
        }
        return this._composer;
    }

    public void setComposer(String composer) {
        this._composer = composer;
    }

    public String getDecomposer() {
        Configuration childConfig;
        if (this._decomposer == null && (childConfig = this.getModelConfiguration().getFirstChild(DECOMPOSER)) != null) {
            this._decomposer = childConfig.getValue();
        }
        return this._decomposer;
    }

    public void setDecomposer(String decomposer) {
        this._decomposer = decomposer;
    }

    public void setPublishAsWS(Boolean publishAsWS) {
        this._publishAsWS = publishAsWS;
    }

    public Boolean getPublishAsWS() {
        return this._publishAsWS;
    }
}

