/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.deploy;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceReference;
import org.switchyard.component.soap.InboundHandler;
import org.switchyard.component.soap.OutboundHandler;
import org.switchyard.component.soap.WebServiceConsumeException;
import org.switchyard.component.soap.WebServicePublishException;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.exception.SwitchYardException;

public class SOAPActivator
extends BaseActivator {
    private static final String SOAP_TYPE = "soap";
    private Map<QName, InboundHandler> _inboundGateways = new HashMap<QName, InboundHandler>();
    private Map<QName, OutboundHandler> _outboundGateways = new HashMap<QName, OutboundHandler>();

    public SOAPActivator() {
        super(new String[]{SOAP_TYPE});
    }

    public ExchangeHandler init(QName name, Model config) {
        if (config instanceof CompositeServiceModel) {
            for (BindingModel binding : ((CompositeServiceModel)config).getBindings()) {
                if (!(binding instanceof SOAPBindingModel)) continue;
                InboundHandler handler = new InboundHandler((SOAPBindingModel)binding);
                this._inboundGateways.put(name, handler);
                return handler;
            }
        }
        if (config instanceof CompositeReferenceModel) {
            for (BindingModel binding : ((CompositeReferenceModel)config).getBindings()) {
                if (!(binding instanceof SOAPBindingModel)) continue;
                OutboundHandler handler = new OutboundHandler((SOAPBindingModel)binding);
                this._outboundGateways.put(name, handler);
                return handler;
            }
        }
        throw new SwitchYardException("No SOAP bindings found for service " + name);
    }

    public void start(ServiceReference service) {
        if (this._inboundGateways.containsKey(service.getName())) {
            try {
                this._inboundGateways.get(service.getName()).start(service);
            }
            catch (WebServicePublishException ex) {
                throw new SwitchYardException("Failed to start inbound gateway for service " + service.getName(), (Throwable)ex);
            }
        }
        if (this._outboundGateways.containsKey(service.getName())) {
            try {
                this._outboundGateways.get(service.getName()).start();
            }
            catch (WebServiceConsumeException ex) {
                throw new SwitchYardException("Failed to start outbound gateway for service " + service.getName(), (Throwable)ex);
            }
        }
    }

    public void stop(ServiceReference service) {
        if (this._inboundGateways.containsKey(service.getName())) {
            this._inboundGateways.get(service.getName()).stop();
        }
        if (this._outboundGateways.containsKey(service.getName())) {
            this._outboundGateways.get(service.getName()).stop();
        }
    }

    public void destroy(ServiceReference service) {
        this._inboundGateways.remove(service.getName());
        this._outboundGateways.remove(service.getName());
    }
}

