/* 
 * JBoss, Home of Professional Open Source 
 * Copyright 2011 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @author tags. All rights reserved. 
 * See the copyright.txt in the distribution for a 
 * full listing of individual contributors.
 *
 * This copyrighted material is made available to anyone wishing to use, 
 * modify, copy, or redistribute it subject to the terms and conditions 
 * of the GNU Lesser General Public License, v. 2.1. 
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details. 
 * You should have received a copy of the GNU Lesser General Public License, 
 * v.2.1 along with this distribution; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 */

package org.switchyard.component.soap;

import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

import org.switchyard.Exchange;
import org.switchyard.Message;

/**
 * Message composer holds the logic for converting SOAP/XML messages to SwitchYard messages.
 *
 * @author Magesh Kumar B <mageshbk@jboss.com> (C) 2011 Red Hat Inc.
 */
public interface MessageComposer {

    /**
     * Converts the SOAPMessage to Message.
     * 
     * @param soapMessage the SOAPMessage to be converted
     * @param exchange the exchange that the message will be a part of
     * @param mappedVariableNames names of headers that should be taken out of the SOAPMessage and into the Exchange's Context
     * @return the composed Message
     * @throws SOAPException If the SOAP message is not correct.
     */
    Message compose(SOAPMessage soapMessage, Exchange exchange, Set<QName> mappedVariableNames) throws SOAPException;
}
