/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.dom.DOMSource;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.component.soap.MessageComposer;

public class DefaultMessageComposer
implements MessageComposer {
    @Override
    public Message compose(SOAPMessage soapMessage, Exchange exchange, Set<QName> mappedVariableNames) throws SOAPException {
        Message message = exchange.createMessage();
        Context context = exchange.getContext();
        try {
            SOAPHeader soapHeader = soapMessage.getSOAPHeader();
            Iterator iter = soapHeader.examineAllHeaderElements();
            while (iter.hasNext()) {
                String value;
                SOAPHeaderElement elem = (SOAPHeaderElement)iter.next();
                QName name = elem.getElementQName();
                if (!mappedVariableNames.contains(elem.getElementQName()) || (value = elem.getValue()) == null) continue;
                context.setProperty(name.toString(), (Object)value, Scope.IN);
            }
        }
        catch (SOAPException se) {
            se.getMessage();
        }
        SOAPBody soapBody = soapMessage.getSOAPBody();
        if (soapBody == null) {
            throw new SOAPException("Missing SOAP body from request");
        }
        Iterator children = soapBody.getChildElements();
        boolean found = false;
        try {
            while (children.hasNext()) {
                Node node = (Node)children.next();
                if (!(node instanceof SOAPElement)) continue;
                if (found) {
                    throw new SOAPException("Found multiple SOAPElements in SOAPBody");
                }
                node.detachNode();
                message.setContent((Object)new DOMSource((org.w3c.dom.Node)node));
                found = true;
            }
        }
        catch (Exception ex) {
            if (ex instanceof SOAPException) {
                throw (SOAPException)((Object)ex);
            }
            throw new SOAPException((Throwable)ex);
        }
        if (!found) {
            throw new SOAPException("Could not find SOAPElement in SOAPBody");
        }
        return message;
    }
}

