/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.component.soap.MessageDecomposer;
import org.switchyard.component.soap.util.SOAPUtil;
import org.w3c.dom.Node;

public class DefaultMessageDecomposer
implements MessageDecomposer {
    @Override
    public SOAPMessage decompose(Exchange exchange, Set<QName> mappedVariableNames) throws SOAPException {
        Message message = exchange.getMessage();
        if (SOAPUtil.SOAP_MESSAGE_FACTORY == null) {
            throw new SOAPException("Failed to instantiate SOAP Message Factory");
        }
        SOAPMessage response = SOAPUtil.SOAP_MESSAGE_FACTORY.createMessage();
        if (message != null) {
            if (message.getContent() == null) {
                throw new SOAPException("Null response from service");
            }
            if (message.getContent() instanceof SOAPMessage) {
                return (SOAPMessage)message.getContent();
            }
            Node input = (Node)message.getContent(Node.class);
            try {
                Node node = response.getSOAPBody().getOwnerDocument().importNode(input, true);
                response.getSOAPBody().appendChild(node);
            }
            catch (Exception e) {
                throw new SOAPException("Unable to parse SOAP Message", (Throwable)e);
            }
        }
        Context context = exchange.getContext();
        SOAPHeader soapHeader = response.getSOAPHeader();
        for (QName name : mappedVariableNames) {
            Object value;
            Property property = context.getProperty(name.toString(), Scope.OUT);
            if (property == null || (value = property.getValue()) == null) continue;
            soapHeader.addChildElement(name).setValue(String.valueOf(value));
        }
        return response;
    }
}

