/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.switchyard.ExchangePattern;
import org.switchyard.ServiceReference;
import org.switchyard.common.type.Classes;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.soap.PortName;
import org.switchyard.component.soap.WebServicePublishException;
import org.switchyard.metadata.BaseExchangeContract;
import org.switchyard.metadata.BaseInvocationContract;
import org.switchyard.metadata.ServiceOperation;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public final class WSDLUtil {
    private static final Logger LOGGER = Logger.getLogger(WSDLUtil.class);
    public static final QName SOAP_FAULT_MESSAGE_TYPE = QName.valueOf("{http://schemas.xmlsoap.org/soap/envelope/}Fault");

    private WSDLUtil() {
    }

    public static Definition readWSDL(String wsdlLocation) throws WSDLException {
        InputStream inputStream = null;
        try {
            URL url = WSDLUtil.getURL(wsdlLocation);
            inputStream = url.openStream();
            InputSource source = new InputSource(inputStream);
            source.setSystemId(url.toString());
            Document wsdlDoc = XMLHelper.getDocument((InputSource)source);
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            WSDLReader reader = wsdlFactory.newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            Definition definition = reader.readWSDL(url.toString(), wsdlDoc);
            return definition;
        }
        catch (Exception e) {
            throw new WSDLException("OTHER_ERROR", "Unable to read WSDL at '" + wsdlLocation, (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    LOGGER.error((Object)ioe);
                }
            }
        }
    }

    public static StreamSource getStream(String wsdlURI) throws WSDLException {
        try {
            URL url = WSDLUtil.getURL(wsdlURI);
            InputStream inputStream = url.openStream();
            StreamSource inputSource = new StreamSource(inputStream);
            inputSource.setSystemId(url.toString());
            return inputSource;
        }
        catch (Exception e) {
            throw new WSDLException("OTHER_ERROR", "Unable to resolve WSDL document at '" + wsdlURI, (Throwable)e);
        }
    }

    public static URL getURL(String path) throws MalformedURLException {
        URL url;
        if (path.startsWith("http://") || path.startsWith("https://") || path.startsWith("file://")) {
            return new URL(null, path);
        }
        try {
            url = Classes.getResource((String)path, WSDLUtil.class);
        }
        catch (IOException ioe) {
            url = null;
        }
        if (url == null) {
            File localFile = new File(path);
            url = localFile.toURI().toURL();
        }
        return url;
    }

    public static Service getService(String wsdlLocation, PortName portName) throws WSDLException {
        Definition definition = WSDLUtil.readWSDL(wsdlLocation);
        Service service = null;
        if (portName.getServiceQName().equals(new QName(""))) {
            service = (Service)definition.getServices().values().iterator().next();
            portName.setServiceQName(service.getQName());
        } else {
            String namespace = portName.getNamespaceURI();
            if (namespace.equals("")) {
                namespace = definition.getTargetNamespace();
            }
            QName serviceQName = new QName(namespace, portName.getServiceName());
            for (Service wsdlService : definition.getServices().values()) {
                if (!wsdlService.getQName().equals(serviceQName)) continue;
                service = wsdlService;
                break;
            }
        }
        if (service == null) {
            throw new WSDLException("Could not find service " + portName + " in the WSDL " + wsdlLocation, null);
        }
        return service;
    }

    public static Port getPort(Service wsdlService, PortName portName) throws WSDLException {
        String name = portName.getName();
        Port port = null;
        if (name == null || name.length() == 0) {
            port = (Port)wsdlService.getPorts().values().iterator().next();
        } else {
            for (Port wsdlPort : wsdlService.getPorts().values()) {
                if (!wsdlPort.getName().equals(name)) continue;
                port = wsdlPort;
                break;
            }
        }
        if (port == null) {
            throw new WSDLException("Could not find port " + portName + " in the Service " + wsdlService.getQName(), null);
        }
        return port;
    }

    public static Operation getOperation(Port port, String elementName) {
        List operations = port.getBinding().getPortType().getOperations();
        for (Operation operation : operations) {
            Part part = (Part)operation.getInput().getMessage().getParts().values().iterator().next();
            if (!elementName.equals(part.getElementName().getLocalPart())) continue;
            return operation;
        }
        return null;
    }

    public static boolean isOneWay(Port port, String elementName) {
        Operation operation = WSDLUtil.getOperation(port, elementName);
        return WSDLUtil.isOneWay(operation);
    }

    public static boolean isOneWay(Operation operation) {
        boolean isOneWay = false;
        if (operation != null) {
            isOneWay = operation.getStyle().equals(OperationType.ONE_WAY);
        }
        return isOneWay;
    }

    public static String getMessageLocalName(Port port, String operationName) {
        QName messageName = WSDLUtil.getMessageQName(port, operationName);
        if (messageName != null) {
            return messageName.getLocalPart();
        }
        return null;
    }

    public static QName getMessageQName(Port port, String operationName) {
        QName messageName = null;
        Operation operation = WSDLUtil.getOperation(port, operationName);
        if (operation != null) {
            messageName = operation.getInput().getMessage().getQName();
        }
        return messageName;
    }

    public static Map<String, BaseExchangeContract> getContracts(Port port, ServiceReference service) throws WebServicePublishException {
        HashMap<String, BaseExchangeContract> contracts = new HashMap<String, BaseExchangeContract>();
        List operations = port.getBinding().getPortType().getOperations();
        if (operations == null || operations.isEmpty()) {
            throw new WebServicePublishException("Invalid WSDL. No operations found.");
        }
        for (Operation operation : operations) {
            String name = operation.getName();
            ServiceOperation targetServiceOperation = service.getInterface().getOperation(name);
            if (targetServiceOperation == null) {
                throw new WebServicePublishException("WSDL Operation " + name + " not found in Service " + service.getName());
            }
            ExchangePattern wsdlExchangePattern = WSDLUtil.getExchangePattern(operation);
            if (targetServiceOperation.getExchangePattern() != wsdlExchangePattern) {
                throw new WebServicePublishException("WSDL Operation " + name + " does not match Service Operation " + targetServiceOperation.getName());
            }
            BaseExchangeContract exchangeContract = new BaseExchangeContract(targetServiceOperation);
            BaseInvocationContract soapMetaData = exchangeContract.getInvokerInvocationMetaData();
            List parts = operation.getInput().getMessage().getOrderedParts(null);
            if (parts.isEmpty()) {
                throw new WebServicePublishException("WSDL Operation " + name + " does not have any input Message parts");
            }
            QName inputMessageQName = ((Part)parts.get(0)).getElementName();
            soapMetaData.setInputType(inputMessageQName);
            soapMetaData.setFaultType(SOAP_FAULT_MESSAGE_TYPE);
            if (!WSDLUtil.isOneWay(operation)) {
                parts = operation.getOutput().getMessage().getOrderedParts(null);
                if (parts.isEmpty()) {
                    throw new WebServicePublishException("WSDL Operation " + name + " does not have any ouput Message parts");
                }
                QName outputMessageQName = ((Part)parts.get(0)).getElementName();
                soapMetaData.setOutputType(outputMessageQName);
            }
            contracts.put(name, exchangeContract);
        }
        return contracts;
    }

    public static ExchangePattern getExchangePattern(Operation operation) {
        if (operation.getStyle().equals(OperationType.ONE_WAY)) {
            return ExchangePattern.IN_ONLY;
        }
        return ExchangePattern.IN_OUT;
    }
}

