/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import java.lang.reflect.InvocationTargetException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.switchyard.component.soap.util.SOAPUtil;
import org.switchyard.component.soap.util.WSDLUtil;
import org.switchyard.config.model.Scannable;
import org.switchyard.transform.BaseTransformer;

@Scannable(value=false)
public class DefaultExceptionTransformer<F extends Exception, T extends SOAPMessage>
extends BaseTransformer<F, T> {
    public QName getFrom() {
        return DefaultExceptionTransformer.toMessageType(Exception.class);
    }

    public QName getTo() {
        return WSDLUtil.SOAP_FAULT_MESSAGE_TYPE;
    }

    public SOAPMessage transform(Exception from) {
        try {
            Throwable cause = from.getCause();
            if (cause instanceof InvocationTargetException) {
                return SOAPUtil.generateFault(cause.getCause());
            }
            return SOAPUtil.generateFault(from);
        }
        catch (SOAPException e1) {
            throw new IllegalStateException("Unexpected SOAPException when generating a SOAP Fault message.", from);
        }
    }
}

