/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import java.net.MalformedURLException;
import java.net.URL;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.soap.PortName;
import org.switchyard.component.soap.WebServiceConsumeException;
import org.switchyard.component.soap.composer.SOAPBindingData;
import org.switchyard.component.soap.composer.SOAPComposition;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.util.SOAPUtil;
import org.switchyard.component.soap.util.WSDLUtil;
import org.switchyard.deploy.BaseServiceHandler;

public class OutboundHandler
extends BaseServiceHandler {
    private static final Logger LOGGER = Logger.getLogger(OutboundHandler.class);
    private final SOAPBindingModel _config;
    private MessageComposer<SOAPBindingData> _messageComposer;
    private Dispatch<SOAPMessage> _dispatcher;
    private Port _wsdlPort;
    private String _bindingId;

    public OutboundHandler(SOAPBindingModel config) {
        this._config = config;
    }

    public void start() throws WebServiceConsumeException {
        if (this._dispatcher == null) {
            ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
            try {
                PortName portName = this._config.getPort();
                javax.wsdl.Service wsdlService = WSDLUtil.getService(this._config.getWsdl(), portName);
                this._wsdlPort = WSDLUtil.getPort(wsdlService, portName);
                portName.setServiceQName(wsdlService.getQName());
                portName.setName(this._wsdlPort.getName());
                this._bindingId = WSDLUtil.getBindingId(this._wsdlPort);
                this._messageComposer = SOAPComposition.getMessageComposer(this._config, this._wsdlPort);
                URL wsdlUrl = WSDLUtil.getURL(this._config.getWsdl());
                LOGGER.info((Object)("Creating dispatch with WSDL " + wsdlUrl));
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                Service service = Service.create((URL)wsdlUrl, (QName)portName.getServiceQName());
                this._dispatcher = service.createDispatch(portName.getPortQName(), SOAPMessage.class, Service.Mode.MESSAGE, new WebServiceFeature[]{new AddressingFeature(false, false)});
                this._dispatcher.getRequestContext().put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
            }
            catch (MalformedURLException e) {
                throw new WebServiceConsumeException(e);
            }
            catch (WSDLException wsdle) {
                throw new WebServiceConsumeException(wsdle);
            }
            finally {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
        }
    }

    public void stop() {
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        try {
            SOAPMessage response;
            SOAPMessage request;
            if (SOAPUtil.getFactory(this._bindingId) == null) {
                throw new SOAPException("Failed to instantiate SOAP Message Factory");
            }
            try {
                request = ((SOAPBindingData)this._messageComposer.decompose(exchange, (BindingData)new SOAPBindingData(SOAPUtil.createMessage(this._bindingId)))).getSOAPMessage();
            }
            catch (Exception e) {
                throw e instanceof SOAPException ? (SOAPException)((Object)e) : new SOAPException((Throwable)e);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Request:[" + SOAPUtil.soapMessageToString(request) + "]"));
            }
            if ((response = this.invokeService(request)) != null) {
                Message message;
                try {
                    message = this._messageComposer.compose((BindingData)new SOAPBindingData(response), exchange, true);
                }
                catch (Exception e) {
                    throw e instanceof SOAPException ? (SOAPException)((Object)e) : new SOAPException((Throwable)e);
                }
                exchange.send(message);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Response:[" + SOAPUtil.soapMessageToString(response) + "]"));
            }
        }
        catch (SOAPException se) {
            throw new HandlerException("Unexpected exception handling SOAP Message", (Throwable)se);
        }
    }

    private SOAPMessage invokeService(SOAPMessage soapMessage) throws SOAPException {
        SOAPMessage response = null;
        try {
            String firstBodyElement = SOAPUtil.getFirstBodyElement(soapMessage);
            String action = WSDLUtil.getSoapAction(this._wsdlPort, firstBodyElement);
            this._dispatcher.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", "\"" + action + "\"");
            if (WSDLUtil.isOneWay(this._wsdlPort, firstBodyElement)) {
                this._dispatcher.invokeOneWay((Object)soapMessage);
            } else {
                response = (SOAPMessage)this._dispatcher.invoke((Object)soapMessage);
            }
        }
        catch (SOAPFaultException sfex) {
            response = SOAPUtil.generateFault(sfex, this._bindingId);
        }
        catch (Exception ex) {
            throw new SOAPException("Cannot process SOAP request", (Throwable)ex);
        }
        return response;
    }
}

