/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.composer;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceContext;
import org.switchyard.component.common.composer.SecurityBindingData;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.extract.SOAPMessageCredentialsExtractor;
import org.switchyard.security.credential.extract.ServletRequestCredentialsExtractor;
import org.switchyard.security.credential.extract.WebServiceContextCredentialsExtractor;

public class SOAPBindingData
implements SecurityBindingData {
    private final SOAPMessage _soapMessage;
    private final WebServiceContext _webServiceContext;

    public SOAPBindingData(SOAPMessage soapMessage) {
        this(soapMessage, null);
    }

    public SOAPBindingData(SOAPMessage soapMessage, WebServiceContext webServiceContext) {
        this._soapMessage = soapMessage;
        this._webServiceContext = webServiceContext;
    }

    public SOAPMessage getSOAPMessage() {
        return this._soapMessage;
    }

    public WebServiceContext getWebServiceContext() {
        return this._webServiceContext;
    }

    public Set<Credential> extractCredentials() {
        HashSet<Credential> credentials = new HashSet<Credential>();
        credentials.addAll(new SOAPMessageCredentialsExtractor().extractCredentials(this.getSOAPMessage()));
        credentials.addAll(new WebServiceContextCredentialsExtractor().extractCredentials(this.getWebServiceContext()));
        credentials.addAll(new ServletRequestCredentialsExtractor().extractCredentials(this.getServletRequest()));
        return credentials;
    }

    private ServletRequest getServletRequest() {
        if (this._webServiceContext != null) {
            return (ServletRequest)this._webServiceContext.getMessageContext().get((Object)"javax.xml.ws.servlet.request");
        }
        return null;
    }
}

