/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.composer;

import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.common.io.pull.ElementPuller;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.common.composer.BaseRegexContextMapper;
import org.switchyard.component.soap.composer.SOAPBindingData;
import org.switchyard.component.soap.composer.SOAPHeadersType;
import org.switchyard.config.Configuration;
import org.switchyard.config.ConfigurationPuller;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPContextMapper
extends BaseRegexContextMapper<SOAPBindingData> {
    private SOAPHeadersType _soapHeadersType = null;

    public SOAPHeadersType getSOAPHeadersType() {
        return this._soapHeadersType;
    }

    public SOAPContextMapper setSOAPHeadersType(SOAPHeadersType soapHeadersType) {
        this._soapHeadersType = soapHeadersType;
        return this;
    }

    public void mapFrom(SOAPBindingData source, Context context) throws Exception {
        SOAPMessage soapMessage = source.getSOAPMessage();
        Iterator mimeHeaders = soapMessage.getMimeHeaders().getAllHeaders();
        while (mimeHeaders.hasNext()) {
            String value;
            MimeHeader mimeHeader = (MimeHeader)mimeHeaders.next();
            String name = mimeHeader.getName();
            if (!this.matches(name) || (value = mimeHeader.getValue()) == null) continue;
            context.setProperty(name, (Object)value, Scope.IN).addLabels(new String[]{"soap_message_mime_header"});
        }
        Iterator soapHeaders = soapMessage.getSOAPHeader().examineAllHeaderElements();
        while (soapHeaders.hasNext()) {
            Object value;
            SOAPHeaderElement soapHeader = (SOAPHeaderElement)soapHeaders.next();
            QName qname = soapHeader.getElementQName();
            if (!this.matches(qname)) continue;
            switch (this._soapHeadersType != null ? this._soapHeadersType : SOAPHeadersType.VALUE) {
                case CONFIG: {
                    value = new ConfigurationPuller().pull((Element)soapHeader);
                    break;
                }
                case DOM: {
                    value = soapHeader;
                    break;
                }
                case VALUE: {
                    value = soapHeader.getValue();
                    break;
                }
                case XML: {
                    value = new ConfigurationPuller().pull((Element)soapHeader).toString();
                    break;
                }
                default: {
                    value = null;
                }
            }
            if (value == null) continue;
            String name = qname.toString();
            context.setProperty(name, value, Scope.EXCHANGE).addLabels(new String[]{"soap_message_header"});
        }
    }

    public void mapTo(Context context, SOAPBindingData target) throws Exception {
        SOAPMessage soapMessage = target.getSOAPMessage();
        MimeHeaders mimeHeaders = soapMessage.getMimeHeaders();
        for (Property property : context.getProperties(Scope.OUT)) {
            Object value;
            String name = property.getName();
            if (!this.matches(name) || (value = property.getValue()) == null) continue;
            mimeHeaders.addHeader(name, String.valueOf(value));
        }
        SOAPHeader soapHeader = soapMessage.getSOAPHeader();
        for (Property property : context.getProperties(Scope.EXCHANGE)) {
            String name = property.getName();
            QName qname = XMLHelper.createQName((String)name);
            boolean qualifiedForSoapHeader = Strings.trimToNull((String)qname.getNamespaceURI()) != null;
            if (!qualifiedForSoapHeader || !this.matches(qname)) continue;
            Object value = property.getValue();
            if (value instanceof Node) {
                Node domNode = soapHeader.getOwnerDocument().importNode((Node)value, true);
                soapHeader.appendChild(domNode);
                continue;
            }
            if (value instanceof Configuration) {
                Element configElement = new ElementPuller().pull((Reader)new StringReader(value.toString()));
                Node configNode = soapHeader.getOwnerDocument().importNode(configElement, true);
                soapHeader.appendChild(configNode);
                continue;
            }
            if (value == null) continue;
            String v = String.valueOf(value);
            if (SOAPHeadersType.XML.equals((Object)this._soapHeadersType)) {
                Element xmlElement = new ElementPuller().pull((Reader)new StringReader(v));
                Node xmlNode = soapHeader.getOwnerDocument().importNode(xmlElement, true);
                soapHeader.appendChild(xmlNode);
                continue;
            }
            soapHeader.addChildElement(qname).setValue(v);
        }
    }
}

