/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.composer;

import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.dom.DOMSource;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeState;
import org.switchyard.Message;
import org.switchyard.component.common.composer.BaseMessageComposer;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.soap.composer.SOAPBindingData;
import org.switchyard.component.soap.config.model.SOAPMessageComposerModel;
import org.switchyard.component.soap.util.SOAPUtil;
import org.switchyard.component.soap.util.WSDLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPMessageComposer
extends BaseMessageComposer<SOAPBindingData> {
    private static Logger _log = Logger.getLogger(SOAPMessageComposer.class);
    private SOAPMessageComposerModel _config;
    private Port _wsdlPort;

    public Message compose(SOAPBindingData source, Exchange exchange, boolean create) throws Exception {
        SOAPMessage soapMessage = source.getSOAPMessage();
        Message message = create ? exchange.createMessage() : exchange.getMessage();
        this.getContextMapper().mapFrom((BindingData)source, exchange.getContext());
        SOAPBody soapBody = soapMessage.getSOAPBody();
        if (soapBody == null) {
            throw new SOAPException("Missing SOAP body from request");
        }
        List<Element> bodyChildren = this.getChildElements((Node)soapBody);
        try {
            String opName;
            if (bodyChildren.size() > 1) {
                throw new SOAPException("Found multiple SOAPElements in SOAPBody");
            }
            if (bodyChildren.size() == 0 || bodyChildren.get(0) == null) {
                throw new SOAPException("Could not find SOAPElement in SOAPBody");
            }
            Node bodyNode = bodyChildren.get(0);
            if (this._config != null && this._config.isUnwrapped() && (opName = exchange.getContract().getConsumerOperation().getName()) != null && opName.equals(bodyNode.getLocalName())) {
                List<Element> subChildren = this.getChildElements(bodyNode);
                if (subChildren.size() == 0 || subChildren.size() > 1) {
                    _log.debug((Object)("Unable to unwrap element: " + bodyNode.getLocalName() + ". A single child element is required."));
                } else {
                    bodyNode = subChildren.get(0);
                }
            }
            bodyNode = bodyNode.getParentNode().removeChild(bodyNode);
            message.setContent((Object)new DOMSource(bodyNode));
        }
        catch (Exception ex) {
            if (ex instanceof SOAPException) {
                throw (SOAPException)ex;
            }
            throw new SOAPException((Throwable)ex);
        }
        return message;
    }

    public SOAPBindingData decompose(Exchange exchange, SOAPBindingData target) throws Exception {
        SOAPMessage soapMessage = target.getSOAPMessage();
        Message message = exchange.getMessage();
        if (message != null) {
            if (message.getContent() == null) {
                throw new SOAPException("Null response from service");
            }
            if (message.getContent() instanceof SOAPMessage) {
                return new SOAPBindingData((SOAPMessage)message.getContent());
            }
            try {
                Node input = (Node)message.getContent(Node.class);
                Node messageNodeImport = soapMessage.getSOAPBody().getOwnerDocument().importNode(input, true);
                if (exchange.getState() != ExchangeState.FAULT || this.isSOAPFaultPayload(input)) {
                    if (this._config != null && this._config.isUnwrapped()) {
                        String opName = exchange.getContract().getProviderOperation().getName();
                        String ns = this.getWrapperNamespace(opName, exchange.getPhase() == null);
                        if (!messageNodeImport.getLocalName().equals(opName)) {
                            Element wrapper = messageNodeImport.getOwnerDocument().createElementNS(ns, opName);
                            wrapper.appendChild(messageNodeImport);
                            messageNodeImport = wrapper;
                        }
                    }
                    soapMessage.getSOAPBody().appendChild(messageNodeImport);
                } else {
                    SOAPUtil.addFault(soapMessage).addDetail().appendChild(messageNodeImport);
                }
            }
            catch (Exception e) {
                if (exchange.getState().equals((Object)ExchangeState.FAULT) && exchange.getMessage().getContent() instanceof Exception) {
                    throw (Exception)exchange.getMessage().getContent(Exception.class);
                }
                throw new SOAPException("Unable to parse SOAP Message", (Throwable)e);
            }
        }
        try {
            this.getContextMapper().mapTo(exchange.getContext(), (BindingData)target);
        }
        catch (Exception ex) {
            throw new SOAPException("Failed to map context properties to SOAP message", (Throwable)ex);
        }
        return target;
    }

    public SOAPMessageComposerModel getComposerConfig() {
        return this._config;
    }

    public void setComposerConfig(SOAPMessageComposerModel composerConfig) {
        this._config = composerConfig;
    }

    private boolean isSOAPFaultPayload(Node messageNode) {
        String nsURI;
        String rootName = messageNode.getLocalName().toLowerCase();
        return rootName.equals("fault") && ((nsURI = messageNode.getNamespaceURI()).equals("http://www.w3.org/2003/05/soap-envelope") || nsURI.equals("http://schemas.xmlsoap.org/soap/envelope/"));
    }

    private List<Element> getChildElements(Node parent) {
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() != 1) continue;
            children.add((Element)nodes.item(i));
        }
        return children;
    }

    private String getWrapperNamespace(String operationName, boolean input) {
        String ns = null;
        if (this._wsdlPort != null) {
            Operation op = WSDLUtil.getOperationByName(this._wsdlPort, operationName);
            List parts = input ? op.getInput().getMessage().getOrderedParts(null) : op.getOutput().getMessage().getOrderedParts(null);
            ns = ((Part)parts.get(0)).getElementName().getNamespaceURI();
        }
        return ns;
    }

    public Port getWsdlPort() {
        return this._wsdlPort;
    }

    public void setWsdlPort(Port wsdlPort) {
        this._wsdlPort = wsdlPort;
    }
}

