/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.endpoint;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.wsdl.WSDLException;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.switchyard.component.soap.InboundHandler;
import org.switchyard.component.soap.WebServicePublishException;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.endpoint.AbstractEndpointPublisher;
import org.switchyard.component.soap.endpoint.JAXWSEndpoint;
import org.switchyard.component.soap.endpoint.WSEndpoint;
import org.switchyard.component.soap.util.WSDLUtil;

public class JAXWSEndpointPublisher
extends AbstractEndpointPublisher {
    private static final Logger LOGGER = Logger.getLogger(JAXWSEndpointPublisher.class);
    private static final String HTTP_SCHEME = "http";

    @Override
    public synchronized WSEndpoint publish(SOAPBindingModel config, String bindingId, InboundHandler handler) {
        JAXWSEndpoint wsEndpoint = null;
        try {
            this.initialize(config);
            ArrayList<StreamSource> metadata = new ArrayList<StreamSource>();
            StreamSource source = WSDLUtil.getStream(config.getWsdl());
            metadata.add(source);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("javax.xml.ws.wsdl.service", config.getPort().getServiceQName());
            properties.put("javax.xml.ws.wsdl.port", config.getPort().getPortQName());
            properties.put("javax.xml.ws.wsdl.description", this.getWsdlLocation());
            String publishUrl = "http://" + config.getSocketAddr().getHost() + ":" + config.getSocketAddr().getPort() + "/" + this.getContextPath();
            LOGGER.info((Object)("Publishing WebService at " + publishUrl));
            wsEndpoint = new JAXWSEndpoint(bindingId, handler);
            wsEndpoint.getEndpoint().setMetadata(metadata);
            wsEndpoint.getEndpoint().setProperties(properties);
            wsEndpoint.getEndpoint().publish(publishUrl);
        }
        catch (MalformedURLException e) {
            throw new WebServicePublishException(e);
        }
        catch (WSDLException e) {
            throw new WebServicePublishException(e);
        }
        return wsEndpoint;
    }
}

