/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.endpoint;

import java.util.Map;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.jboss.wsf.spi.publish.Context;
import org.jboss.wsf.spi.publish.EndpointPublisher;
import org.jboss.wsf.spi.publish.EndpointPublisherFactory;
import org.switchyard.component.soap.InboundHandler;
import org.switchyard.component.soap.WebServicePublishException;
import org.switchyard.component.soap.endpoint.BaseWebService;
import org.switchyard.component.soap.endpoint.WSEndpoint;

public class JBossWSEndpoint
implements WSEndpoint {
    private static final Logger LOG = Logger.getLogger(JBossWSEndpoint.class);
    private static final String HOST = "default-host";
    private static final EndpointPublisherFactory FACTORY;
    private EndpointPublisher _publisher;
    private Context _context;

    public JBossWSEndpoint() throws Exception {
        this._publisher = FACTORY.newEndpointPublisher(HOST);
    }

    public JBossWSEndpoint(String host) throws Exception {
        this._publisher = FACTORY.newEndpointPublisher(host);
    }

    public void publish(String contextRoot, Map<String, String> urlPatternToClassNameMap, WebservicesMetaData metadata, InboundHandler handler) throws Exception {
        this._context = this._publisher.publish(contextRoot, Thread.currentThread().getContextClassLoader(), urlPatternToClassNameMap, metadata);
        for (Endpoint ep : this._context.getEndpoints()) {
            BaseWebService wsProvider = (BaseWebService)ep.getInstanceProvider().getInstance(BaseWebService.class.getName()).getValue();
            wsProvider.setInvocationClassLoader(Thread.currentThread().getContextClassLoader());
            wsProvider.setConsumer(handler);
        }
    }

    @Override
    public void stop() {
        if (this._context != null && this._publisher != null) {
            try {
                this._publisher.destroy(this._context);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }

    static {
        try {
            ClassLoader loader = ClassLoaderProvider.getDefaultProvider().getWebServiceSubsystemClassLoader();
            FACTORY = ServiceLoader.load(EndpointPublisherFactory.class, loader).iterator().next();
        }
        catch (Exception e) {
            throw new WebServicePublishException(e);
        }
    }
}

