/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.util;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.log4j.Logger;
import org.switchyard.common.xml.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class SOAPUtil {
    private static final Logger LOGGER = Logger.getLogger(SOAPUtil.class);
    public static final String SOAP11_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String SOAP12_URI = "http://www.w3.org/2003/05/soap-envelope";
    public static final QName SOAP11_SERVER_FAULT_TYPE = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
    public static final QName SOAP11_FAULT_MESSAGE_TYPE = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
    public static final QName SOAP12_RECEIVER_FAULT_TYPE = new QName("http://www.w3.org/2003/05/soap-envelope", "Receiver");
    public static final QName SOAP12_FAULT_MESSAGE_TYPE = new QName("http://www.w3.org/2003/05/soap-envelope", "Fault");
    private static final boolean RETURN_STACK_TRACES = false;
    private static final MessageFactory SOAP11_MESSAGE_FACTORY;
    private static final MessageFactory SOAP12_MESSAGE_FACTORY;

    private SOAPUtil() {
    }

    public static String getFirstBodyElement(SOAPMessage soapMessage) throws SOAPException {
        String operationName = null;
        SOAPBody body = soapMessage.getSOAPPart().getEnvelope().getBody();
        if (body != null) {
            Iterator nodes = body.getChildElements();
            Node node = null;
            while (nodes.hasNext()) {
                node = (Node)nodes.next();
                if (!(node instanceof Element)) continue;
                operationName = node.getLocalName();
            }
        }
        return operationName;
    }

    public static Boolean isSOAP12(SOAPMessage soapMessage) throws SOAPException {
        return soapMessage.getSOAPPart().getEnvelope().getNamespaceURI().equals(SOAP12_URI);
    }

    public static SOAPFault addFault(SOAPMessage soapMessage) throws SOAPException {
        if (SOAPUtil.isSOAP12(soapMessage).booleanValue()) {
            return soapMessage.getSOAPBody().addFault(SOAP12_FAULT_MESSAGE_TYPE, "Send failed");
        }
        return soapMessage.getSOAPBody().addFault(SOAP12_FAULT_MESSAGE_TYPE, "Send failed");
    }

    public static SOAPMessage generateFault(Throwable th, String bindingId) throws SOAPException {
        if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) {
            return SOAPUtil.generateSOAP12Fault(th);
        }
        return SOAPUtil.generateSOAP11Fault(th);
    }

    public static SOAPMessage generateSOAP11Fault(Throwable th) throws SOAPException {
        SOAPMessage faultMsg = SOAP11_MESSAGE_FACTORY.createMessage();
        return SOAPUtil.generateFault(th, faultMsg, SOAP11_SERVER_FAULT_TYPE);
    }

    public static SOAPMessage generateSOAP12Fault(Throwable th) throws SOAPException {
        SOAPMessage faultMsg = SOAP12_MESSAGE_FACTORY.createMessage();
        return SOAPUtil.generateFault(th, faultMsg, SOAP12_RECEIVER_FAULT_TYPE);
    }

    private static SOAPMessage generateFault(Throwable th, SOAPMessage faultMsg, QName faultQname) throws SOAPException {
        if (LOGGER.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            th.printStackTrace(pw);
            pw.flush();
            pw.close();
            LOGGER.debug((Object)sw.toString());
        }
        if (th instanceof SOAPFaultException) {
            SOAPFault exFault = ((SOAPFaultException)th).getFault();
            SOAPFault fault = faultMsg.getSOAPBody().addFault(exFault.getFaultCodeAsQName(), exFault.getFaultString());
            fault.addNamespaceDeclaration(fault.getElementQName().getPrefix(), faultQname.getNamespaceURI());
            fault.setFaultActor(exFault.getFaultActor());
            if (exFault.hasDetail()) {
                Detail exDetail = exFault.getDetail();
                Detail detail = fault.addDetail();
                Iterator entries = exDetail.getDetailEntries();
                while (entries.hasNext()) {
                    Node entryImport = detail.getOwnerDocument().importNode((Node)entries.next(), true);
                    detail.appendChild(entryImport);
                }
            }
        } else {
            String message = th.getMessage();
            if (message == null) {
                message = th.toString();
            }
            faultMsg.getSOAPBody().addFault(faultQname, message);
        }
        return faultMsg;
    }

    public static Document parseAsDom(String soapRes) throws ParserConfigurationException, XMLStreamException {
        XMLEventReader reader = XMLHelper.getXMLEventReader((Reader)new StringReader(soapRes));
        return XMLHelper.createDocument((XMLEventReader)reader);
    }

    public static String soapMessageToString(SOAPMessage msg) {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            StringWriter sw = new StringWriter();
            DOMSource source = new DOMSource(msg.getSOAPPart().getDocumentElement());
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
            return sw.toString();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Could not parse SOAP Message", (Throwable)e);
            return null;
        }
    }

    public static SOAPMessage createMessage(String bindingId) throws SOAPException {
        SOAPMessage message = null;
        message = bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") ? SOAP12_MESSAGE_FACTORY.createMessage() : SOAP11_MESSAGE_FACTORY.createMessage();
        return message;
    }

    public static MessageFactory getFactory(String bindingId) {
        MessageFactory factory = null;
        factory = bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") ? SOAP12_MESSAGE_FACTORY : SOAP11_MESSAGE_FACTORY;
        return factory;
    }

    static {
        MessageFactory soapMessageFactory = null;
        try {
            soapMessageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException soape) {
            LOGGER.error((Object)"Could not instantiate SOAP 1.1 Message Factory", (Throwable)soape);
        }
        SOAP11_MESSAGE_FACTORY = soapMessageFactory;
        soapMessageFactory = null;
        try {
            soapMessageFactory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
        }
        catch (SOAPException soape) {
            LOGGER.error((Object)"Could not instantiate SOAP 1.2 Message Factory", (Throwable)soape);
        }
        SOAP12_MESSAGE_FACTORY = soapMessageFactory;
    }
}

