/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import java.util.List;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceContext;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.SynchronousInOutHandler;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.soap.PortName;
import org.switchyard.component.soap.WebServicePublishException;
import org.switchyard.component.soap.composer.SOAPBindingData;
import org.switchyard.component.soap.composer.SOAPComposition;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.endpoint.EndpointPublisherFactory;
import org.switchyard.component.soap.endpoint.WSEndpoint;
import org.switchyard.component.soap.util.SOAPUtil;
import org.switchyard.component.soap.util.WSDLUtil;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.exception.DeliveryException;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.security.SecurityContext;
import org.w3c.dom.Node;

public class InboundHandler
extends BaseServiceHandler {
    private static final Logger LOGGER = Logger.getLogger(InboundHandler.class);
    private static final long DEFAULT_TIMEOUT = 15000L;
    private static final String MESSAGE_NAME = "org.switchyard.soap.messageName";
    private final SOAPBindingModel _config;
    private MessageComposer<SOAPBindingData> _messageComposer;
    private ServiceDomain _domain;
    private ServiceReference _service;
    private long _waitTimeout = 15000L;
    private WSEndpoint _endpoint;
    private Port _wsdlPort;
    private String _bindingId;
    private Boolean _documentStyle = false;

    public InboundHandler(SOAPBindingModel config, ServiceDomain domain) {
        this._config = config;
        this._domain = domain;
    }

    public void start() throws WebServicePublishException {
        try {
            this._service = this._domain.getServiceReference(this._config.getServiceName());
            PortName portName = this._config.getPort();
            Service wsdlService = WSDLUtil.getService(this._config.getWsdl(), portName);
            this._wsdlPort = WSDLUtil.getPort(wsdlService, portName);
            portName.setServiceQName(wsdlService.getQName());
            portName.setName(this._wsdlPort.getName());
            this._bindingId = WSDLUtil.getBindingId(this._wsdlPort);
            String style = WSDLUtil.getStyle(this._wsdlPort);
            this._documentStyle = style.equals("document");
            this._endpoint = EndpointPublisherFactory.getEndpointPublisher().publish(this._config, this._bindingId, this);
            this._messageComposer = SOAPComposition.getMessageComposer(this._config, this._wsdlPort);
        }
        catch (WSDLException e) {
            throw new WebServicePublishException(e);
        }
    }

    public void stop() {
        if (this._endpoint != null) {
            this._endpoint.stop();
        }
        LOGGER.info((Object)("WebService " + this._config.getPort() + " stopped."));
    }

    public void handleFault(Exchange exchange) {
        throw new IllegalStateException("Unexpected");
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        throw new IllegalStateException("Unexpected");
    }

    public SOAPMessage invoke(SOAPMessage soapMessage) {
        return this.invoke(soapMessage, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPMessage invoke(SOAPMessage soapMessage, WebServiceContext wsContext) {
        Operation operation;
        String operationName = null;
        Boolean oneWay = false;
        String firstBodyElement = null;
        if (soapMessage == null || soapMessage.getSOAPPart() == null) {
            return this.handleException(oneWay, new SOAPException("No such operation: " + this._wsdlPort.getName() + "->null"));
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Request:[" + SOAPUtil.soapMessageToString(soapMessage) + "]"));
        }
        try {
            firstBodyElement = SOAPUtil.getFirstBodyElement(soapMessage);
            operation = this._documentStyle != false ? WSDLUtil.getOperationByElement(this._wsdlPort, firstBodyElement) : WSDLUtil.getOperationByName(this._wsdlPort, firstBodyElement);
            if (operation != null) {
                operationName = operation.getName();
                oneWay = WSDLUtil.isOneWay(operation);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Received SOAP message targeted at Webservice operation '" + operationName + "' on port '" + this._wsdlPort.getName() + "'."));
                }
            }
        }
        catch (SOAPException e) {
            LOGGER.error((Object)e);
            return null;
        }
        if (operation == null) {
            return this.handleException(oneWay, new SOAPException("Operation for '" + firstBodyElement + "' not available on target Service '" + this._service.getName() + "'."));
        }
        try {
            SOAPMessage soapResponse;
            Message message;
            SynchronousInOutHandler inOutHandler = new SynchronousInOutHandler();
            Exchange exchange = this._service.createExchange(operationName, (ExchangeHandler)inOutHandler);
            SOAPBindingData soapBindingData = new SOAPBindingData(soapMessage, wsContext);
            SecurityContext.get().getCredentials().addAll(soapBindingData.extractCredentials());
            try {
                message = this._messageComposer.compose((BindingData)soapBindingData, exchange, true);
            }
            catch (Exception e) {
                throw e instanceof SOAPException ? (SOAPException)((Object)e) : new SOAPException((Throwable)e);
            }
            if (this._config.getSOAPMessageComposer() == null || !this._config.getSOAPMessageComposer().isUnwrapped()) {
                this.assertComposedMessageOK(message, operation);
            }
            exchange.getContext().setProperty(MESSAGE_NAME, (Object)operation.getInput().getMessage().getQName().getLocalPart(), Scope.IN);
            if (oneWay.booleanValue()) {
                exchange.send(message);
                SOAPMessage e = null;
                return e;
            }
            exchange.send(message);
            try {
                exchange = inOutHandler.waitForOut(this._waitTimeout);
            }
            catch (DeliveryException e) {
                SOAPMessage sOAPMessage = this.handleException(oneWay, new SOAPException("Timed out after " + this._waitTimeout + " ms waiting on synchronous response from target service '" + this._service.getName() + "'."));
                SecurityContext.clear();
                return sOAPMessage;
            }
            if (SOAPUtil.getFactory(this._bindingId) == null) {
                throw new SOAPException("Failed to instantiate SOAP Message Factory");
            }
            try {
                soapResponse = ((SOAPBindingData)this._messageComposer.decompose(exchange, (BindingData)new SOAPBindingData(SOAPUtil.createMessage(this._bindingId)))).getSOAPMessage();
            }
            catch (SOAPException soapEx) {
                throw soapEx;
            }
            catch (Exception ex) {
                throw new SwitchYardException(ex.getMessage());
            }
            if (exchange.getState() == ExchangeState.FAULT && soapResponse.getSOAPBody().getFault() == null) {
                SOAPMessage sOAPMessage = this.handleException(oneWay, new SOAPException("Invalid response SOAPMessage construction.  The associated SwitchYard Exchange is in a FAULT state, but the SOAPMessage is not a Fault message.  The MessageComposer implementation in use (" + this._messageComposer.getClass().getName() + ") must generate the SOAPMessage instance properly as a Fault message."));
                return sOAPMessage;
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Response:[" + SOAPUtil.soapMessageToString(soapResponse) + "]"));
            }
            SOAPMessage sOAPMessage = soapResponse;
            return sOAPMessage;
        }
        catch (SOAPException se) {
            SOAPMessage sOAPMessage = this.handleException(oneWay, se);
            return sOAPMessage;
        }
        finally {
            SecurityContext.clear();
        }
    }

    private void assertComposedMessageOK(Message soapMessage, Operation operation) throws SOAPException {
        Node inputMessage = (Node)soapMessage.getContent(Node.class);
        String actualNS = inputMessage.getNamespaceURI();
        String actualLN = inputMessage.getLocalName();
        List parts = operation.getInput().getMessage().getOrderedParts(null);
        if (parts.isEmpty()) {
            throw new SOAPException("Invalid input SOAP payload for service operation '" + operation.getName() + "' (service '" + this._service.getName() + "').  No such Part '" + actualLN + "'.");
        }
        Part part = (Part)parts.get(0);
        QName expectedPayloadType = part.getElementName();
        String expectedNS = expectedPayloadType.getNamespaceURI();
        String expectedLN = expectedPayloadType.getLocalPart();
        if (!this._documentStyle.booleanValue()) {
            expectedLN = operation.getName();
        }
        if (expectedNS != null && !expectedNS.equals(actualNS)) {
            throw new SOAPException("Invalid input SOAP payload namespace for service operation '" + operation.getName() + "' (service '" + this._service.getName() + "').  Port defines operation namespace as '" + expectedNS + "'.  Actual namespace on input SOAP message '" + actualNS + "'.");
        }
        if (expectedLN != null && !expectedLN.equals(actualLN)) {
            throw new SOAPException("Invalid input SOAP payload localNamePart for service operation '" + operation.getName() + "' (service '" + this._service.getName() + "').  Port defines operation localNamePart as '" + expectedLN + "'.  Actual localNamePart on input SOAP message '" + actualLN + "'.");
        }
    }

    private SOAPMessage handleException(Boolean oneWay, SOAPException se) {
        if (oneWay.booleanValue()) {
            LOGGER.error((Object)se);
        } else {
            try {
                return SOAPUtil.generateFault(se, this._bindingId);
            }
            catch (SOAPException e) {
                LOGGER.error((Object)e);
            }
        }
        return null;
    }
}

