/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.endpoint;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.switchyard.component.soap.InboundHandler;
import org.switchyard.component.soap.WebServicePublishException;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.endpoint.AbstractEndpointPublisher;
import org.switchyard.component.soap.endpoint.JBossWSEndpoint;
import org.switchyard.component.soap.endpoint.WSEndpoint;

public class JBossWSEndpointPublisher
extends AbstractEndpointPublisher {
    private static final Logger LOGGER = Logger.getLogger(JBossWSEndpointPublisher.class);
    private static final String SEI = "org.switchyard.component.soap.endpoint.BaseWebService";

    @Override
    public synchronized WSEndpoint publish(SOAPBindingModel config, String bindingId, InboundHandler handler) {
        JBossWSEndpoint wsEndpoint = null;
        try {
            this.initialize(config);
            WebservicesMetaData metadata = new WebservicesMetaData();
            WebserviceDescriptionMetaData webserviceDescription = new WebserviceDescriptionMetaData(metadata);
            metadata.addWebserviceDescription(webserviceDescription);
            webserviceDescription.setWsdlFile(this.getWsdlLocation());
            PortComponentMetaData portComponent = new PortComponentMetaData(webserviceDescription);
            portComponent.setPortComponentName(config.getServiceName() + ":" + config.getPort().getServiceQName().getLocalPart() + ":" + config.getPort().getPortQName().getLocalPart());
            portComponent.setServiceEndpointInterface(SEI);
            portComponent.setWsdlPort(config.getPort().getPortQName());
            portComponent.setWsdlService(config.getPort().getServiceQName());
            webserviceDescription.addPortComponent(portComponent);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("/" + config.getPort().getServiceName(), SEI);
            wsEndpoint = new JBossWSEndpoint();
            if (config.getContextPath() != null) {
                wsEndpoint.publish(this.getContextRoot(), map, metadata, handler);
            } else {
                wsEndpoint.publish(this.getContextPath(), map, metadata, handler);
            }
        }
        catch (Exception e) {
            throw new WebServicePublishException(e);
        }
        return wsEndpoint;
    }
}

