/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.switchyard.ExchangePattern;
import org.switchyard.common.type.Classes;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.soap.PortName;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public final class WSDLUtil {
    private static final Logger LOGGER = Logger.getLogger(WSDLUtil.class);
    public static final String WSDL_SOAP11_URI = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String WSDL_SOAP12_URI = "http://schemas.xmlsoap.org/wsdl/soap12/";
    public static final String DOCUMENT = "document";

    private WSDLUtil() {
    }

    public static Definition readWSDL(String wsdlLocation) throws WSDLException {
        InputStream inputStream = null;
        try {
            URL url = WSDLUtil.getURL(wsdlLocation);
            inputStream = url.openStream();
            InputSource source = new InputSource(inputStream);
            source.setSystemId(url.toString());
            Document wsdlDoc = XMLHelper.getDocument((InputSource)source);
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            WSDLReader reader = wsdlFactory.newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            Definition definition = reader.readWSDL(url.toString(), wsdlDoc);
            return definition;
        }
        catch (Exception e) {
            throw new WSDLException("OTHER_ERROR", "Unable to read WSDL at '" + wsdlLocation, (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    LOGGER.error((Object)ioe);
                }
            }
        }
    }

    public static StreamSource getStream(String wsdlURI) throws WSDLException {
        try {
            URL url = WSDLUtil.getURL(wsdlURI);
            InputStream inputStream = url.openStream();
            StreamSource inputSource = new StreamSource(inputStream);
            inputSource.setSystemId(url.toString());
            return inputSource;
        }
        catch (Exception e) {
            throw new WSDLException("OTHER_ERROR", "Unable to resolve WSDL document at '" + wsdlURI, (Throwable)e);
        }
    }

    public static URL getURL(String path) throws MalformedURLException {
        URL url;
        if (path.startsWith("http://") || path.startsWith("https://") || path.startsWith("file://")) {
            return new URL(null, path);
        }
        try {
            url = Classes.getResource((String)path, WSDLUtil.class);
        }
        catch (IOException ioe) {
            url = null;
        }
        if (url == null) {
            File localFile = new File(path);
            url = localFile.toURI().toURL();
        }
        return url;
    }

    public static Service getService(String wsdlLocation, PortName portName) throws WSDLException {
        Definition definition = WSDLUtil.readWSDL(wsdlLocation);
        Service service = null;
        if (portName.getServiceQName().equals(new QName(""))) {
            service = (Service)definition.getServices().values().iterator().next();
            portName.setServiceQName(service.getQName());
        } else {
            String namespace = portName.getNamespaceURI();
            if (namespace.equals("")) {
                namespace = definition.getTargetNamespace();
            }
            QName serviceQName = new QName(namespace, portName.getServiceName());
            for (Service wsdlService : definition.getServices().values()) {
                if (!wsdlService.getQName().equals(serviceQName)) continue;
                service = wsdlService;
                break;
            }
        }
        if (service == null) {
            throw new WSDLException("Could not find service " + portName + " in the WSDL " + wsdlLocation, null);
        }
        return service;
    }

    public static Port getPort(Service wsdlService, PortName portName) throws WSDLException {
        String name = portName.getName();
        Port port = null;
        if (name == null || name.length() == 0) {
            port = (Port)wsdlService.getPorts().values().iterator().next();
        } else {
            for (Port wsdlPort : wsdlService.getPorts().values()) {
                if (!wsdlPort.getName().equals(name)) continue;
                port = wsdlPort;
                break;
            }
        }
        if (port == null) {
            throw new WSDLException("Could not find port " + portName + " in the Service " + wsdlService.getQName(), null);
        }
        return port;
    }

    public static String getStyle(Port port) {
        String style = DOCUMENT;
        for (ExtensibilityElement element : port.getBinding().getExtensibilityElements()) {
            if (!(element instanceof SOAPBinding)) continue;
            style = ((SOAPBinding)element).getStyle().toLowerCase();
        }
        return style;
    }

    public static Operation getOperationByElement(Port port, String elementName) {
        List operations = port.getBinding().getPortType().getOperations();
        for (Operation operation : operations) {
            Part part = (Part)operation.getInput().getMessage().getParts().values().iterator().next();
            if (!elementName.equals(part.getElementName().getLocalPart())) continue;
            return operation;
        }
        return null;
    }

    public static Operation getOperationByName(Port port, String operationName) {
        Operation operation = null;
        List operationList = port.getBinding().getPortType().getOperations();
        for (Operation op : operationList) {
            if (!op.getName().equals(operationName)) continue;
            operation = op;
            break;
        }
        return operation;
    }

    public static String getBindingId(Port port) {
        String bindingId;
        block0: {
            ExtensibilityElement extElement;
            bindingId = "http://schemas.xmlsoap.org/wsdl/soap/http";
            List extElements = port.getExtensibilityElements();
            Iterator i$ = extElements.iterator();
            if (!i$.hasNext() || !(extElement = (ExtensibilityElement)i$.next()).getElementType().getNamespaceURI().equals(WSDL_SOAP12_URI)) break block0;
            bindingId = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
        }
        return bindingId;
    }

    public static boolean isOneWay(Port port, String elementName) {
        Operation operation = WSDLUtil.getOperationByElement(port, elementName);
        return WSDLUtil.isOneWay(operation);
    }

    public static boolean isOneWay(Operation operation) {
        boolean isOneWay = false;
        if (operation != null) {
            isOneWay = operation.getStyle().equals(OperationType.ONE_WAY);
        }
        return isOneWay;
    }

    public static BindingOperation getBindingOperation(Port port, String elementName) {
        Operation operation = WSDLUtil.getOperationByElement(port, elementName);
        if (operation != null) {
            List bindingOperations = port.getBinding().getBindingOperations();
            for (BindingOperation bindingOperation : bindingOperations) {
                if (!bindingOperation.getName().equals(operation.getName())) continue;
                return bindingOperation;
            }
        }
        return null;
    }

    public static String getSoapAction(Port port, String elementName) {
        BindingOperation operation = WSDLUtil.getBindingOperation(port, elementName);
        return WSDLUtil.getSoapAction(operation);
    }

    public static String getSoapAction(BindingOperation operation) {
        String soapActionUri = "";
        if (operation != null) {
            List extElements = operation.getExtensibilityElements();
            for (ExtensibilityElement extElement : extElements) {
                if (extElement instanceof SOAPOperation) {
                    soapActionUri = ((SOAPOperation)extElement).getSoapActionURI();
                    break;
                }
                if (!(extElement instanceof SOAP12Operation)) continue;
                SOAP12Operation soapOperation = (SOAP12Operation)extElement;
                Boolean soapActionRequired = soapOperation.getSoapActionRequired();
                if (soapActionRequired != null && !soapActionRequired.booleanValue()) break;
                soapActionUri = soapOperation.getSoapActionURI();
                break;
            }
        }
        return soapActionUri;
    }

    public static String getMessageLocalName(Port port, String operationName) {
        QName messageName = WSDLUtil.getMessageQName(port, operationName);
        if (messageName != null) {
            return messageName.getLocalPart();
        }
        return null;
    }

    public static QName getMessageQName(Port port, String operationName) {
        QName messageName = null;
        Operation operation = WSDLUtil.getOperationByElement(port, operationName);
        if (operation != null) {
            messageName = operation.getInput().getMessage().getQName();
        }
        return messageName;
    }

    public static ExchangePattern getExchangePattern(Operation operation) {
        if (operation.getStyle().equals(OperationType.ONE_WAY)) {
            return ExchangePattern.IN_ONLY;
        }
        return ExchangePattern.IN_OUT;
    }
}

