/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.SwitchYardException;
import org.switchyard.component.common.DeliveryException;
import org.switchyard.component.common.SynchronousInOutHandler;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.soap.Feature;
import org.switchyard.component.soap.PortName;
import org.switchyard.component.soap.WebServicePublishException;
import org.switchyard.component.soap.composer.SOAPBindingData;
import org.switchyard.component.soap.composer.SOAPComposition;
import org.switchyard.component.soap.composer.SOAPMessageComposer;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.endpoint.EndpointPublisherFactory;
import org.switchyard.component.soap.endpoint.WSEndpoint;
import org.switchyard.component.soap.util.SOAPUtil;
import org.switchyard.component.soap.util.WSDLUtil;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.security.SecurityContext;
import org.w3c.dom.Node;

public class InboundHandler
extends BaseServiceHandler {
    private static final Logger LOGGER = Logger.getLogger(InboundHandler.class);
    private static final long DEFAULT_TIMEOUT = 15000L;
    private static final int DEFAULT_FAULT_RESONSE_CODE = 500;
    private static final String MESSAGE_NAME = "org.switchyard.soap.messageName";
    private final SOAPBindingModel _config;
    private final String _gatewayName;
    private MessageComposer<SOAPBindingData> _messageComposer;
    private ServiceDomain _domain;
    private ServiceReference _service;
    private long _waitTimeout = 15000L;
    private WSEndpoint _endpoint;
    private Port _wsdlPort;
    private String _bindingId;
    private Boolean _documentStyle = false;
    private Boolean _unwrapped = false;
    private String _targetNamespace;
    private Feature _feature = new Feature();
    private Map<String, Operation> _operationsMap = new HashMap<String, Operation>();

    public InboundHandler(SOAPBindingModel config, ServiceDomain domain) {
        super(domain);
        this._config = config;
        this._gatewayName = config.getName();
        this._domain = domain;
    }

    protected void doStart() throws WebServicePublishException {
        try {
            this._service = this._domain.getServiceReference(this._config.getServiceName());
            PortName portName = this._config.getPort();
            Definition definition = WSDLUtil.readWSDL(this._config.getWsdl());
            this._targetNamespace = definition.getTargetNamespace();
            Service wsdlService = WSDLUtil.getService(definition, portName);
            this._wsdlPort = WSDLUtil.getPort(wsdlService, portName);
            portName.setServiceQName(wsdlService.getQName());
            portName.setName(this._wsdlPort.getName());
            String style = WSDLUtil.getStyle(this._wsdlPort);
            this._documentStyle = style.equals("document");
            this._unwrapped = this._config.isUnwrapped();
            this._feature = WSDLUtil.getFeature(definition, this._wsdlPort, this._documentStyle);
            if (this._feature.isAddressingEnabled().booleanValue()) {
                List bindingOperations = this._wsdlPort.getBinding().getBindingOperations();
                for (BindingOperation bindingOp : bindingOperations) {
                    String inputAction = WSDLUtil.getInputAction(this._wsdlPort, new QName(this._targetNamespace, bindingOp.getOperation().getName()), this._targetNamespace, this._documentStyle);
                    this._operationsMap.put(inputAction, bindingOp.getOperation());
                }
            }
            MTOMFeature mtom = this._feature.getMtom(this._config);
            this._bindingId = WSDLUtil.getBindingId(this._wsdlPort, mtom.isEnabled());
            this._endpoint = EndpointPublisherFactory.getEndpointPublisher().publish(this._config, this._bindingId, this, new WebServiceFeature[]{this._feature.getAddressing(), mtom});
            this._messageComposer = SOAPComposition.getMessageComposer(this._config);
            ((SOAPMessageComposer)this._messageComposer).setDocumentStyle(this._documentStyle);
            ((SOAPMessageComposer)this._messageComposer).setWsdlPort(this._wsdlPort);
            ((SOAPMessageComposer)this._messageComposer).setMtomEnabled(mtom.isEnabled());
            ((SOAPMessageComposer)this._messageComposer).setUnwrapped(this._unwrapped);
            if (this._config.getMtomConfig() != null) {
                ((SOAPMessageComposer)this._messageComposer).setXopExpand(this._config.getMtomConfig().isXopExpand());
            }
        }
        catch (WSDLException e) {
            throw new WebServicePublishException(e);
        }
    }

    protected void doStop() {
        if (this._endpoint != null) {
            this._endpoint.stop();
        }
        LOGGER.info((Object)("WebService " + this._config.getPort() + " stopped."));
    }

    public void handleFault(Exchange exchange) {
        throw new IllegalStateException("Unexpected");
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        throw new IllegalStateException("Unexpected");
    }

    public SOAPMessage invoke(SOAPMessage soapMessage) {
        return this.invoke(soapMessage, null);
    }

    public SOAPMessage invoke(SOAPMessage soapMessage, WebServiceContext wsContext) {
        Operation operation;
        String operationName = null;
        Boolean oneWay = false;
        QName firstBodyElement = null;
        MessageContext msgContext = null;
        if (wsContext != null) {
            msgContext = wsContext.getMessageContext();
        }
        if (soapMessage == null || soapMessage.getSOAPPart() == null) {
            return this.handleException(oneWay, new SOAPException("No such operation: " + this._wsdlPort.getName() + "->null"));
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Inbound <-- Request:[" + SOAPUtil.soapMessageToString(soapMessage) + "]"));
        }
        try {
            String action = SOAPUtil.getAddressingAction(soapMessage);
            if (this._feature.isAddressingEnabled().booleanValue() && action != null) {
                operation = this._operationsMap.get(action);
                if (operation == null) {
                    return this.handleException(oneWay, new SOAPException("Could not find any operation associated with WS-A Action '" + action + "'."));
                }
            } else {
                firstBodyElement = SOAPUtil.getFirstBodyElement(soapMessage);
                operation = WSDLUtil.getOperationByElement(this._wsdlPort, firstBodyElement, this._documentStyle);
            }
            if (operation != null) {
                operationName = operation.getName();
                oneWay = WSDLUtil.isOneWay(operation);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Received SOAP message targeted at Webservice operation '" + operationName + "' on port '" + this._wsdlPort.getName() + "'."));
                }
            }
        }
        catch (SOAPException e) {
            LOGGER.error((Object)e);
            return null;
        }
        if (operation == null) {
            return this.handleException(oneWay, new SOAPException("Operation for '" + firstBodyElement + "' not available on target Service '" + this._service.getName() + "'."));
        }
        try {
            SOAPMessage soapResponse;
            Message message;
            SynchronousInOutHandler inOutHandler = new SynchronousInOutHandler();
            Exchange exchange = this._service.createExchange(operationName, (ExchangeHandler)inOutHandler);
            exchange.getContext().setProperty("org.switchyard.exchangeGatewayName", (Object)this._gatewayName, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
            SOAPBindingData soapBindingData = new SOAPBindingData(soapMessage, wsContext);
            SecurityContext.get((Exchange)exchange).getCredentials().addAll(soapBindingData.extractCredentials());
            try {
                message = this._messageComposer.compose((BindingData)soapBindingData, exchange);
            }
            catch (Exception e) {
                throw e instanceof SOAPException ? (SOAPException)((Object)e) : new SOAPException((Throwable)e);
            }
            if (!this._unwrapped.booleanValue()) {
                this.assertComposedMessageOK(message, operation);
            }
            exchange.getContext(message).setProperty(MESSAGE_NAME, (Object)operation.getInput().getMessage().getQName().getLocalPart());
            if (oneWay.booleanValue()) {
                exchange.send(message);
                return null;
            }
            exchange.send(message);
            try {
                exchange = inOutHandler.waitForOut(this._waitTimeout);
            }
            catch (DeliveryException e) {
                return this.handleException(oneWay, new SOAPException("Timed out after " + this._waitTimeout + " ms waiting on synchronous response from target service '" + this._service.getName() + "'."));
            }
            if (SOAPUtil.getFactory(this._bindingId) == null) {
                throw new SOAPException("Failed to instantiate SOAP Message Factory");
            }
            try {
                SOAPBindingData bindingData = new SOAPBindingData(SOAPUtil.createMessage(this._bindingId));
                soapResponse = ((SOAPBindingData)this._messageComposer.decompose(exchange, (BindingData)bindingData)).getSOAPMessage();
                if (msgContext != null) {
                    msgContext.put((Object)"org.switchyard.http.status", (Object)bindingData.getStatus());
                }
            }
            catch (SOAPException soapEx) {
                throw soapEx;
            }
            catch (Exception ex) {
                throw new SwitchYardException((Throwable)ex);
            }
            if (exchange.getState() == ExchangeState.FAULT && soapResponse.getSOAPBody().getFault() == null) {
                return this.handleException(oneWay, new SOAPException("Invalid response SOAPMessage construction.  The associated SwitchYard Exchange is in a FAULT state, but the SOAPMessage is not a Fault message.  The MessageComposer implementation in use (" + this._messageComposer.getClass().getName() + ") must generate the SOAPMessage instance properly as a Fault message."));
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Inbound --> Response:[" + SOAPUtil.soapMessageToString(soapResponse) + "]"));
            }
            return soapResponse;
        }
        catch (SOAPException se) {
            if (msgContext != null) {
                msgContext.put((Object)"org.switchyard.http.status", (Object)500);
            }
            return this.handleException(oneWay, se);
        }
    }

    private void assertComposedMessageOK(Message soapMessage, Operation operation) throws SOAPException {
        Node inputMessage = (Node)soapMessage.getContent(Node.class);
        String actualNS = inputMessage.getNamespaceURI();
        String actualLN = inputMessage.getLocalName();
        List parts = operation.getInput().getMessage().getOrderedParts(null);
        if (parts.isEmpty()) {
            throw new SOAPException("Invalid input SOAP payload for service operation '" + operation.getName() + "' (service '" + this._service.getName() + "').  No such Part '" + actualLN + "'.");
        }
        QName expectedPayloadType = null;
        if (this._documentStyle.booleanValue()) {
            if (((Part)parts.get(0)).getElementName() != null) {
                expectedPayloadType = ((Part)parts.get(0)).getElementName();
            } else if (((Part)parts.get(0)).getTypeName() != null) {
                expectedPayloadType = ((Part)parts.get(0)).getTypeName();
            }
        } else {
            expectedPayloadType = new QName(this._targetNamespace, operation.getName());
        }
        String expectedNS = expectedPayloadType.getNamespaceURI();
        String expectedLN = expectedPayloadType.getLocalPart();
        if (!this._documentStyle.booleanValue()) {
            expectedLN = operation.getName();
        }
        if (expectedNS != null && !expectedNS.equals(actualNS)) {
            throw new SOAPException("Invalid input SOAP payload namespace for service operation '" + operation.getName() + "' (service '" + this._service.getName() + "').  Port defines operation namespace as '" + expectedNS + "'.  Actual namespace on input SOAP message '" + actualNS + "'.");
        }
        if (expectedLN != null && !expectedLN.equals(actualLN)) {
            throw new SOAPException("Invalid input SOAP payload localNamePart for service operation '" + operation.getName() + "' (service '" + this._service.getName() + "').  Port defines operation localNamePart as '" + expectedLN + "'.  Actual localNamePart on input SOAP message '" + actualLN + "'.");
        }
    }

    private SOAPMessage handleException(Boolean oneWay, SOAPException se) {
        if (oneWay.booleanValue()) {
            LOGGER.error((Object)se);
        } else {
            try {
                return SOAPUtil.generateFault(se, this._bindingId);
            }
            catch (SOAPException e) {
                LOGGER.error((Object)e);
            }
        }
        return null;
    }
}

