/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.log4j.Logger;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.common.codec.Base64;
import org.switchyard.common.xml.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public final class SOAPUtil {
    private static final Logger LOGGER = Logger.getLogger(SOAPUtil.class);
    public static final String SWITCHYARD_CONTEXT = "SWITCHYARD_CONTEXT";
    public static final String SOAP11_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String SOAP12_URI = "http://www.w3.org/2003/05/soap-envelope";
    public static final String WSA_URI = "http://www.w3.org/2005/08/addressing";
    public static final String MTOM_XOP_URI = "http://www.w3.org/2004/08/xop/include";
    public static final QName SOAP11_SERVER_FAULT_TYPE = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
    public static final QName SOAP11_FAULT_MESSAGE_TYPE = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
    public static final QName SOAP12_RECEIVER_FAULT_TYPE = new QName("http://www.w3.org/2003/05/soap-envelope", "Receiver");
    public static final QName SOAP12_FAULT_MESSAGE_TYPE = new QName("http://www.w3.org/2003/05/soap-envelope", "Fault");
    public static final QName WSA_ACTION_QNAME = new QName("http://www.w3.org/2005/08/addressing", "Action");
    public static final QName WSA_FROM_QNAME = new QName("http://www.w3.org/2005/08/addressing", "From");
    public static final QName WSA_MESSAGEID_QNAME = new QName("http://www.w3.org/2005/08/addressing", "MessageID");
    public static final QName WSA_REPLYTO_QNAME = new QName("http://www.w3.org/2005/08/addressing", "ReplyTo");
    public static final QName WSA_FAULTTO_QNAME = new QName("http://www.w3.org/2005/08/addressing", "FaultTo");
    public static final QName WSA_RELATESTO_QNAME = new QName("http://www.w3.org/2005/08/addressing", "RelatesTo");
    public static final QName WSA_TO_QNAME = new QName("http://www.w3.org/2005/08/addressing", "To");
    public static final QName MTOM_XOP_INCLUDE_QNAME = new QName("http://www.w3.org/2004/08/xop/include", "Include");
    public static final String WSA_ACTION_STR = WSA_ACTION_QNAME.toString();
    public static final String WSA_FROM_STR = WSA_FROM_QNAME.toString();
    public static final String WSA_FAULTTO_STR = WSA_FAULTTO_QNAME.toString();
    public static final String WSA_REPLYTO_STR = WSA_REPLYTO_QNAME.toString();
    public static final String WSA_RELATESTO_STR = WSA_RELATESTO_QNAME.toString();
    public static final String WSA_TO_STR = WSA_TO_QNAME.toString();
    private static final boolean RETURN_STACK_TRACES = false;
    private static final String INDENT_FEATURE = "{http://xml.apache.org/xslt}indent-amount";
    private static final String INDENT_AMOUNT = "4";
    private static final String CID_STR = "cid:";
    private static final String HREF_STR = "href";
    private static final MessageFactory SOAP11_MESSAGE_FACTORY;
    private static final MessageFactory SOAP12_MESSAGE_FACTORY;

    private SOAPUtil() {
    }

    public static QName getFirstBodyElement(SOAPMessage soapMessage) throws SOAPException {
        QName operationName = null;
        SOAPBody body = soapMessage.getSOAPPart().getEnvelope().getBody();
        if (body != null) {
            Iterator nodes = body.getChildElements();
            org.w3c.dom.Node node = null;
            while (nodes.hasNext()) {
                node = (org.w3c.dom.Node)nodes.next();
                if (!(node instanceof Element)) continue;
                operationName = new QName(node.getNamespaceURI(), node.getLocalName());
            }
        }
        return operationName;
    }

    public static Boolean isSOAP12(SOAPMessage soapMessage) throws SOAPException {
        return soapMessage.getSOAPPart().getEnvelope().getNamespaceURI().equals(SOAP12_URI);
    }

    public static String getAddressingAction(SOAPMessage soapMessage) throws SOAPException {
        String action = null;
        Iterator headers = soapMessage.getSOAPPart().getEnvelope().getHeader().examineAllHeaderElements();
        while (headers.hasNext()) {
            SOAPHeaderElement element = (SOAPHeaderElement)headers.next();
            if (!element.getElementQName().equals(WSA_ACTION_QNAME)) continue;
            action = element.getValue();
            break;
        }
        return action;
    }

    public static SOAPEnvelope addReplaceAddressingHeaders(SOAPMessageContext soapContext) throws SOAPException {
        SOAPEnvelope soapEnvelope = soapContext.getMessage().getSOAPPart().getEnvelope();
        Context context = (Context)soapContext.get((Object)SWITCHYARD_CONTEXT);
        if (context != null) {
            soapEnvelope = SOAPUtil.addReplaceHeader(soapEnvelope, context, WSA_ACTION_STR);
            soapEnvelope = SOAPUtil.addReplaceHeader(soapEnvelope, context, WSA_FROM_STR);
            soapEnvelope = SOAPUtil.addReplaceHeader(soapEnvelope, context, WSA_TO_STR);
            soapEnvelope = SOAPUtil.addReplaceHeader(soapEnvelope, context, WSA_REPLYTO_STR);
            soapEnvelope = SOAPUtil.addReplaceHeader(soapEnvelope, context, WSA_FAULTTO_STR);
            soapEnvelope = SOAPUtil.addReplaceHeader(soapEnvelope, context, WSA_RELATESTO_STR);
        }
        return soapEnvelope;
    }

    public static SOAPEnvelope addReplaceHeader(SOAPEnvelope soapEnvelope, Context context, String property) throws SOAPException {
        org.w3c.dom.Node header = (org.w3c.dom.Node)context.getPropertyValue(property);
        if (header == null) {
            header = (org.w3c.dom.Node)context.getPropertyValue(property.toLowerCase());
        }
        if (header != null) {
            NodeList headers = soapEnvelope.getHeader().getElementsByTagNameNS(header.getNamespaceURI(), header.getLocalName());
            if (headers.getLength() == 1) {
                ((Node)headers.item(0)).detachNode();
            }
            org.w3c.dom.Node domNode = soapEnvelope.getHeader().getOwnerDocument().importNode(header, true);
            soapEnvelope.getHeader().appendChild(domNode);
        }
        return soapEnvelope;
    }

    public static void setMessageIDtoContext(SOAPMessageContext context) throws SOAPException {
        SOAPEnvelope soapEnvelope = context.getMessage().getSOAPPart().getEnvelope();
        String messageID = SOAPUtil.getMessageID(soapEnvelope);
        if (messageID != null) {
            context.put((Object)WSA_MESSAGEID_QNAME.getLocalPart(), (Object)messageID);
            context.setScope(WSA_MESSAGEID_QNAME.getLocalPart(), MessageContext.Scope.APPLICATION);
        }
    }

    public static String getMessageID(SOAPEnvelope soapEnvelope) throws SOAPException {
        NodeList headers = soapEnvelope.getHeader().getElementsByTagNameNS(WSA_ACTION_QNAME.getNamespaceURI(), WSA_ACTION_QNAME.getLocalPart());
        if (headers.getLength() == 1) {
            return ((Node)headers.item(0)).getValue();
        }
        return null;
    }

    public static String getToAddress(Context context) {
        String address = null;
        Property toProp = context.getProperty(WSA_TO_STR);
        if (toProp == null) {
            toProp = context.getProperty(WSA_TO_STR.toLowerCase());
        }
        if (toProp != null) {
            Element toEl = (Element)toProp.getValue();
            address = toEl.getFirstChild().getNodeValue();
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element expandXop(Element element, Map<String, DataSource> attachmentMap) throws IOException {
        if (element != null) {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                org.w3c.dom.Node node = children.item(i);
                if (node.getNodeType() != 1) continue;
                QName name = new QName(node.getNamespaceURI(), node.getLocalName());
                if (name.equals(MTOM_XOP_INCLUDE_QNAME)) {
                    String contentId = XMLHelper.getAttribute((Element)((Element)node), (String)"", (String)HREF_STR);
                    if (contentId.startsWith(CID_STR)) {
                        contentId = contentId.substring(4);
                    }
                    if (attachmentMap.get(contentId = URLDecoder.decode(contentId, "UTF-8")) == null) {
                        throw new RuntimeException("No attachment found with name '" + contentId + "'");
                    }
                    InputStream is = attachmentMap.get(contentId).getInputStream();
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    byte[] buff = new byte[128];
                    try {
                        int read;
                        while ((read = is.read(buff)) != -1) {
                            os.write(buff, 0, read);
                        }
                    }
                    finally {
                        os.flush();
                        os.close();
                        is.close();
                    }
                    String imageString = Base64.encode((byte[])os.toByteArray());
                    Text content = element.getOwnerDocument().createTextNode(imageString);
                    element.removeChild(node);
                    element.appendChild(content);
                    attachmentMap.remove(contentId);
                    continue;
                }
                SOAPUtil.expandXop((Element)node, attachmentMap);
            }
            return element;
        }
        return null;
    }

    public static SOAPFault addFault(SOAPMessage soapMessage) throws SOAPException {
        if (SOAPUtil.isSOAP12(soapMessage).booleanValue()) {
            return soapMessage.getSOAPBody().addFault(SOAP12_FAULT_MESSAGE_TYPE, "Send failed");
        }
        return soapMessage.getSOAPBody().addFault(SOAP11_FAULT_MESSAGE_TYPE, "Send failed");
    }

    public static SOAPMessage generateFault(Throwable th, String bindingId) throws SOAPException {
        if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) {
            return SOAPUtil.generateSOAP12Fault(th);
        }
        return SOAPUtil.generateSOAP11Fault(th);
    }

    public static SOAPMessage generateSOAP11Fault(Throwable th) throws SOAPException {
        SOAPMessage faultMsg = SOAP11_MESSAGE_FACTORY.createMessage();
        return SOAPUtil.generateFault(th, faultMsg, SOAP11_SERVER_FAULT_TYPE);
    }

    public static SOAPMessage generateSOAP12Fault(Throwable th) throws SOAPException {
        SOAPMessage faultMsg = SOAP12_MESSAGE_FACTORY.createMessage();
        return SOAPUtil.generateFault(th, faultMsg, SOAP12_RECEIVER_FAULT_TYPE);
    }

    private static SOAPMessage generateFault(Throwable th, SOAPMessage faultMsg, QName faultQname) throws SOAPException {
        if (LOGGER.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            th.printStackTrace(pw);
            pw.flush();
            pw.close();
            LOGGER.debug((Object)sw.toString());
        }
        if (th instanceof SOAPFaultException) {
            SOAPFault exFault = ((SOAPFaultException)th).getFault();
            SOAPFault fault = faultMsg.getSOAPBody().addFault(exFault.getFaultCodeAsQName(), exFault.getFaultString());
            fault.addNamespaceDeclaration(fault.getElementQName().getPrefix(), faultQname.getNamespaceURI());
            fault.setFaultActor(exFault.getFaultActor());
            if (exFault.hasDetail()) {
                Detail exDetail = exFault.getDetail();
                Detail detail = fault.addDetail();
                Iterator entries = exDetail.getDetailEntries();
                while (entries.hasNext()) {
                    org.w3c.dom.Node entryImport = detail.getOwnerDocument().importNode((org.w3c.dom.Node)entries.next(), true);
                    detail.appendChild(entryImport);
                }
            }
        } else {
            String message = th.getMessage();
            if (message == null) {
                message = th.toString();
            }
            faultMsg.getSOAPBody().addFault(faultQname, message);
        }
        return faultMsg;
    }

    public static Document parseAsDom(String soapRes) throws ParserConfigurationException, IOException, SAXException {
        return XMLHelper.getDocumentFromString((String)soapRes);
    }

    public static String soapMessageToString(SOAPMessage msg) {
        String str = null;
        if (msg != null) {
            try {
                str = XMLHelper.toPretty((org.w3c.dom.Node)msg.getSOAPPart().getDocumentElement());
            }
            catch (Exception e) {
                LOGGER.error((Object)"Could not parse SOAP Message", (Throwable)e);
            }
        }
        return str;
    }

    public static void prettyPrint(Element element, PrintStream out) {
        try {
            out.println(XMLHelper.toPretty((org.w3c.dom.Node)element));
        }
        catch (Exception e) {
            LOGGER.error((Object)"Could not parse SOAP Message", (Throwable)e);
        }
    }

    public static void prettyPrint(SOAPMessage msg, PrintStream out) {
        SOAPUtil.prettyPrint(msg.getSOAPPart().getDocumentElement(), out);
    }

    public static void prettyPrint(String msg, PrintStream out) {
        try {
            SOAPUtil.prettyPrint(XMLHelper.getDocumentFromString((String)msg).getDocumentElement(), out);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Could not parse Message String", (Throwable)e);
        }
    }

    public static SOAPMessage createMessage(String bindingId) throws SOAPException {
        SOAPMessage message = null;
        message = bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") ? SOAP12_MESSAGE_FACTORY.createMessage() : SOAP11_MESSAGE_FACTORY.createMessage();
        return message;
    }

    public static MessageFactory getFactory(String bindingId) {
        MessageFactory factory = null;
        factory = bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") ? SOAP12_MESSAGE_FACTORY : SOAP11_MESSAGE_FACTORY;
        return factory;
    }

    static {
        MessageFactory soapMessageFactory = null;
        try {
            soapMessageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException soape) {
            LOGGER.error((Object)"Could not instantiate SOAP 1.1 Message Factory", (Throwable)soape);
        }
        SOAP11_MESSAGE_FACTORY = soapMessageFactory;
        soapMessageFactory = null;
        try {
            soapMessageFactory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
        }
        catch (SOAPException soape) {
            LOGGER.error((Object)"Could not instantiate SOAP 1.2 Message Factory", (Throwable)soape);
        }
        SOAP12_MESSAGE_FACTORY = soapMessageFactory;
    }
}

