/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.switchyard.ExchangePattern;
import org.switchyard.SwitchYardException;
import org.switchyard.common.type.Classes;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.soap.Feature;
import org.switchyard.component.soap.PortName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class WSDLUtil {
    private static final Logger LOGGER = Logger.getLogger(WSDLUtil.class);
    public static final String WSDL_SOAP11_URI = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String WSDL_SOAP12_URI = "http://schemas.xmlsoap.org/wsdl/soap12/";
    public static final String DOCUMENT = "document";
    private static final String SCHEME_URN = "urn:";
    private static final String STR_ACTION = "Action";
    private static final String STR_COLON = ":";
    private static final String STR_SLASH = "/";
    private static final String STR_FAULT = "Fault";
    private static final String REQUEST_SUFFIX = "Request";
    private static final String RESPONSE_SUFFIX = "Response";
    private static final String ATTR_ID = "Id";
    private static final String ATTR_REQUIRED = "required";
    private static final String ATTR_URI = "URI";
    private static final String ATTR_EXP_CT = "expectedContentTypes";
    private static final String ATTR_LOCATION = "location";
    private static final String ELE_ADDRESSING = "Addressing";
    private static final String ELE_ALL = "All";
    private static final String ELE_EXACTLYONE = "ExactlyOne";
    private static final String ELE_MTOM = "MTOM";
    private static final String WSA_METADATA_URI = "http://www.w3.org/2007/05/addressing/metadata";
    private static final String WSA_WSDL_URI = "http://www.w3.org/2006/05/addressing/wsdl";
    private static final String POLICY_URI = "http://www.w3.org/ns/ws-policy";
    private static final String WS_MTOM_URI = "http://www.w3.org/2007/08/soap12-mtom-policy";
    private static final String WSDL_XMIME_URI = "http://www.w3.org/2005/05/xmlmime";
    private static final String SECURITY_UTILITY_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private static final String WSDL11_URI = "http://schemas.xmlsoap.org/wsdl/";
    private static final QName USING_WSA_QNAME = new QName("http://www.w3.org/2006/05/addressing/wsdl", "UsingAddressing");
    private static final QName POLICY_QNAME = new QName("http://www.w3.org/ns/ws-policy", "Policy");
    private static final QName POLICY_REFERENCE_QNAME = new QName("http://www.w3.org/ns/ws-policy", "PolicyReference");
    private static final QName POLICY_EXACTLYONE_QNAME = new QName("http://www.w3.org/ns/ws-policy", "ExactlyOne");
    private static final QName POLICY_ALL_QNAME = new QName("http://www.w3.org/ns/ws-policy", "All");
    private static final QName WSA_QNAME = new QName("http://www.w3.org/2007/05/addressing/metadata", "Addressing");
    private static final QName WSDL_ACTION_QNAME = new QName("http://www.w3.org/2006/05/addressing/wsdl", "Action");
    private static final QName WSDL_MTOM_QNAME = new QName("http://www.w3.org/2007/08/soap12-mtom-policy", "MTOM");
    private static final QName MTOM_EXPT_QNAME = new QName("http://www.w3.org/2005/05/xmlmime", "expectedContentTypes");

    private WSDLUtil() {
    }

    public static Definition readWSDL(String wsdlLocation) throws WSDLException {
        InputStream inputStream = null;
        try {
            URL url = WSDLUtil.getURL(wsdlLocation);
            inputStream = url.openStream();
            InputSource source = new InputSource(inputStream);
            source.setSystemId(url.toString());
            Document wsdlDoc = XMLHelper.getDocument((InputSource)source);
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            WSDLReader reader = wsdlFactory.newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            Definition definition = reader.readWSDL(url.toString(), wsdlDoc);
            return definition;
        }
        catch (Exception e) {
            throw new WSDLException("OTHER_ERROR", "Unable to read WSDL at '" + wsdlLocation, (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    LOGGER.error((Object)ioe);
                }
            }
        }
    }

    public static StreamSource getStream(String wsdlURI) throws WSDLException {
        try {
            URL url = WSDLUtil.getURL(wsdlURI);
            InputStream inputStream = url.openStream();
            StreamSource inputSource = new StreamSource(inputStream);
            inputSource.setSystemId(url.toString());
            return inputSource;
        }
        catch (Exception e) {
            throw new WSDLException("OTHER_ERROR", "Unable to resolve WSDL document at '" + wsdlURI, (Throwable)e);
        }
    }

    public static URL getURL(String path) throws MalformedURLException {
        URL url;
        if (path.startsWith("http://") || path.startsWith("https://") || path.startsWith("file://")) {
            return new URL(null, path);
        }
        try {
            url = Classes.getResource((String)path, WSDLUtil.class);
        }
        catch (IOException ioe) {
            url = null;
        }
        if (url == null) {
            File localFile = new File(path);
            url = localFile.toURI().toURL();
        }
        return url;
    }

    public static Service getService(String wsdlLocation, PortName portName) throws WSDLException {
        Definition definition = WSDLUtil.readWSDL(wsdlLocation);
        return WSDLUtil.getService(definition, portName);
    }

    public static Service getService(Definition definition, PortName portName) throws WSDLException {
        Service service = null;
        if (portName.getServiceQName().equals(new QName(""))) {
            service = (Service)definition.getServices().values().iterator().next();
            portName.setServiceQName(service.getQName());
        } else {
            String namespace = portName.getNamespaceURI();
            if (namespace.equals("")) {
                namespace = definition.getTargetNamespace();
            }
            QName serviceQName = new QName(namespace, portName.getServiceName());
            for (Service wsdlService : definition.getServices().values()) {
                if (!wsdlService.getQName().equals(serviceQName)) continue;
                service = wsdlService;
                break;
            }
        }
        if (service == null) {
            throw new WSDLException("Could not find service " + portName + " in the WSDL " + definition.getDocumentBaseURI(), null);
        }
        return service;
    }

    public static Port getPort(Service wsdlService, PortName portName) throws WSDLException {
        String name = portName.getName();
        Port port = null;
        if (name == null || name.length() == 0) {
            try {
                port = (Port)wsdlService.getPorts().values().iterator().next();
            }
            catch (NoSuchElementException nsee) {
                throw new WSDLException("Could not find a port definition within service " + wsdlService.getQName(), null);
            }
        } else {
            for (Port wsdlPort : wsdlService.getPorts().values()) {
                if (!wsdlPort.getName().equals(name)) continue;
                port = wsdlPort;
                break;
            }
        }
        if (port == null) {
            throw new WSDLException("Could not find port " + portName + " in the Service " + wsdlService.getQName(), null);
        }
        return port;
    }

    public static String getStyle(Port port) {
        String portStyle = null;
        String bindingStyle = null;
        for (ExtensibilityElement element : port.getBinding().getExtensibilityElements()) {
            if (element instanceof SOAPBinding && ((SOAPBinding)element).getStyle() != null) {
                bindingStyle = ((SOAPBinding)element).getStyle();
            } else if (element instanceof SOAP12Binding && ((SOAP12Binding)element).getStyle() != null) {
                bindingStyle = ((SOAP12Binding)element).getStyle();
            }
            if (bindingStyle == null) continue;
            portStyle = bindingStyle.toLowerCase();
        }
        String operationStyle = null;
        String currentOperationStyle = null;
        for (BindingOperation operation : port.getBinding().getBindingOperations()) {
            for (ExtensibilityElement element : operation.getExtensibilityElements()) {
                if (element instanceof SOAPOperation) {
                    currentOperationStyle = ((SOAPOperation)element).getStyle();
                } else if (element instanceof SOAP12Operation) {
                    currentOperationStyle = ((SOAP12Operation)element).getStyle();
                }
                if (currentOperationStyle == null) continue;
                if (operationStyle != null && !currentOperationStyle.equals(operationStyle)) {
                    throw new SwitchYardException("Incompatible style of soap operation level bindings detected");
                }
                operationStyle = currentOperationStyle;
            }
        }
        if (operationStyle != null && portStyle != null) {
            if (!portStyle.equals(operationStyle)) {
                throw new SwitchYardException("Detected mixing different soap binding style on port type and operation level");
            }
            return portStyle;
        }
        if (portStyle != null) {
            return portStyle;
        }
        if (operationStyle != null) {
            return operationStyle;
        }
        return DOCUMENT;
    }

    public static Operation getOperationByElement(Port port, QName elementName, Boolean documentStyle) {
        List operations = port.getBinding().getPortType().getOperations();
        for (Operation operation : operations) {
            if (!documentStyle.booleanValue() && elementName.getLocalPart().equals(operation.getName())) {
                return operation;
            }
            Part part = (Part)operation.getInput().getMessage().getParts().values().iterator().next();
            if (part.getElementName() != null && elementName.equals(part.getElementName()) || part.getTypeName() != null && elementName.equals(part.getTypeName())) {
                return operation;
            }
            if (!elementName.getLocalPart().equals(operation.getName())) continue;
            return operation;
        }
        return null;
    }

    public static Operation getOperationByName(Port port, String operationName) {
        Operation operation = null;
        List operationList = port.getBinding().getPortType().getOperations();
        for (Operation op : operationList) {
            if (!op.getName().equals(operationName)) continue;
            operation = op;
            break;
        }
        return operation;
    }

    public static String getBindingId(Port port, Boolean mtomEnabled) {
        String bindingId;
        block0: {
            bindingId = null;
            List extElements = port.getExtensibilityElements();
            Iterator i$ = extElements.iterator();
            if (!i$.hasNext()) break block0;
            ExtensibilityElement extElement = (ExtensibilityElement)i$.next();
            bindingId = extElement instanceof SOAP12Address ? (mtomEnabled.booleanValue() ? "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true" : "http://www.w3.org/2003/05/soap/bindings/HTTP/") : (mtomEnabled.booleanValue() ? "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true" : "http://schemas.xmlsoap.org/wsdl/soap/http");
        }
        return bindingId;
    }

    public static String getEndpointAddress(Port port) {
        String address = null;
        List extElements = port.getExtensibilityElements();
        for (ExtensibilityElement extElement : extElements) {
            if (extElement instanceof SOAPAddress) {
                address = ((SOAPAddress)extElement).getLocationURI();
                break;
            }
            if (!(extElement instanceof SOAP12Address)) continue;
            address = ((SOAP12Address)extElement).getLocationURI();
            break;
        }
        return address;
    }

    public static boolean isOneWay(Port port, QName elementName, Boolean documentStyle) {
        Operation operation = WSDLUtil.getOperationByElement(port, elementName, documentStyle);
        return WSDLUtil.isOneWay(operation);
    }

    public static boolean isOneWay(Operation operation) {
        boolean isOneWay = false;
        if (operation != null) {
            isOneWay = operation.getStyle().equals(OperationType.ONE_WAY);
        }
        return isOneWay;
    }

    public static BindingOperation getBindingOperation(Port port, QName elementName, Boolean documentStyle) {
        Operation operation = WSDLUtil.getOperationByElement(port, elementName, documentStyle);
        if (operation != null) {
            List bindingOperations = port.getBinding().getBindingOperations();
            for (BindingOperation bindingOperation : bindingOperations) {
                if (!bindingOperation.getName().equals(operation.getName())) continue;
                return bindingOperation;
            }
        }
        return null;
    }

    public static String getSoapAction(Port port, QName elementName, Boolean documentStyle) {
        BindingOperation operation = WSDLUtil.getBindingOperation(port, elementName, documentStyle);
        return WSDLUtil.getSoapAction(operation);
    }

    public static String getSoapAction(BindingOperation operation) {
        String soapActionUri = "";
        if (operation != null) {
            List extElements = operation.getExtensibilityElements();
            for (ExtensibilityElement extElement : extElements) {
                if (extElement instanceof SOAPOperation) {
                    soapActionUri = ((SOAPOperation)extElement).getSoapActionURI();
                    break;
                }
                if (!(extElement instanceof SOAP12Operation)) continue;
                SOAP12Operation soapOperation = (SOAP12Operation)extElement;
                Boolean soapActionRequired = soapOperation.getSoapActionRequired();
                if (soapActionRequired != null && !soapActionRequired.booleanValue()) break;
                soapActionUri = soapOperation.getSoapActionURI();
                break;
            }
        }
        return soapActionUri;
    }

    public static String getInputAction(Port port, QName operationName, String targetNamespace, Boolean documentStyle) {
        Operation operation = WSDLUtil.getOperationByElement(port, operationName, documentStyle);
        String action = null;
        for (QName attribute : operation.getInput().getExtensionAttributes().keySet()) {
            Object value;
            if (!attribute.equals(WSDL_ACTION_QNAME) || (value = operation.getInput().getExtensionAttribute(WSDL_ACTION_QNAME)) == null) continue;
            action = ((QName)value).getLocalPart();
            break;
        }
        if (action == null) {
            String delimiter = targetNamespace.startsWith(SCHEME_URN) ? STR_COLON : STR_SLASH;
            String namespace = targetNamespace.endsWith(delimiter) ? targetNamespace.substring(0, targetNamespace.length() - 2) : targetNamespace;
            action = operation.getInput().getName() != null ? namespace + delimiter + port.getBinding().getPortType().getQName().getLocalPart() + delimiter + operation.getInput().getName() : namespace + delimiter + port.getBinding().getPortType().getQName().getLocalPart() + delimiter + operation.getName() + REQUEST_SUFFIX;
        }
        return action;
    }

    public static String getOutputAction(Port port, QName operationName, String targetNamespace, Boolean documentStyle) {
        Operation operation = WSDLUtil.getOperationByElement(port, operationName, documentStyle);
        String action = null;
        for (QName attribute : operation.getOutput().getExtensionAttributes().keySet()) {
            Object value;
            if (!attribute.equals(WSDL_ACTION_QNAME) || (value = operation.getOutput().getExtensionAttribute(WSDL_ACTION_QNAME)) == null) continue;
            action = ((QName)value).getLocalPart();
            break;
        }
        if (action == null) {
            String delimiter = targetNamespace.startsWith(SCHEME_URN) ? STR_COLON : STR_SLASH;
            String namespace = targetNamespace.endsWith(delimiter) ? targetNamespace.substring(0, targetNamespace.length() - 2) : targetNamespace;
            action = operation.getOutput().getName() != null ? namespace + delimiter + port.getBinding().getPortType().getQName().getLocalPart() + delimiter + operation.getOutput().getName() : namespace + delimiter + port.getBinding().getPortType().getQName().getLocalPart() + delimiter + operation.getName() + RESPONSE_SUFFIX;
        }
        return action;
    }

    public static String getFaultAction(Port port, QName operationName, String targetNamespace, String faultName, Boolean documentStyle) {
        Operation operation = WSDLUtil.getOperationByElement(port, operationName, documentStyle);
        String action = null;
        if (operation.getFault(faultName) == null) {
            throw new IllegalArgumentException("Fault name " + faultName + " not found on operation " + operationName.getLocalPart());
        }
        for (QName attribute : operation.getFault(faultName).getExtensionAttributes().keySet()) {
            Object value;
            if (!attribute.equals(WSDL_ACTION_QNAME) || (value = operation.getFault(faultName).getExtensionAttribute(WSDL_ACTION_QNAME)) == null) continue;
            action = ((QName)value).getLocalPart();
            break;
        }
        if (action == null) {
            String delimiter = targetNamespace.startsWith(SCHEME_URN) ? STR_COLON : STR_SLASH;
            String namespace = targetNamespace.endsWith(delimiter) ? targetNamespace.substring(0, targetNamespace.length() - 2) : targetNamespace;
            action = namespace + delimiter + port.getBinding().getPortType().getQName().getLocalPart() + delimiter + operationName.getLocalPart() + delimiter + STR_FAULT + delimiter + faultName;
        }
        return action;
    }

    public static Feature getFeature(Definition definition, Port port, Boolean documentStyle) {
        Feature feature = new Feature();
        Boolean addressing = false;
        Boolean mtom = false;
        if (documentStyle.booleanValue()) {
            for (ExtensibilityElement element : definition.getTypes().getExtensibilityElements()) {
                if (!(element instanceof Schema) || !(mtom = WSDLUtil.setMtomEnabled((Schema)element)).booleanValue()) continue;
                feature.setMtomEnabled(true);
                break;
            }
        } else {
            for (Message message : definition.getMessages().values()) {
                for (Part part : message.getOrderedParts(null)) {
                    if (part.getExtensionAttribute(MTOM_EXPT_QNAME) == null) continue;
                    feature.setMtomEnabled(true);
                }
            }
        }
        block3: for (ExtensibilityElement element : port.getBinding().getExtensibilityElements()) {
            if (!(element instanceof UnknownExtensibilityElement)) continue;
            String attrValue = null;
            Element domElement = ((UnknownExtensibilityElement)element).getElement();
            if (element.getElementType().equals(USING_WSA_QNAME)) {
                feature.setAddressingEnabled(true);
                WSDLUtil.setAddressingRequired(feature, domElement);
                break;
            }
            if (!element.getElementType().equals(POLICY_REFERENCE_QNAME)) continue;
            String uri = XMLHelper.getAttribute((Element)domElement, (String)WSDL11_URI, (String)ATTR_URI);
            if (uri == null) {
                throw new RuntimeException("Policy reference URI missing for " + port.getBinding().getQName().getLocalPart());
            }
            uri = uri.substring(1);
            for (ExtensibilityElement defElement : definition.getExtensibilityElements()) {
                Element defDomElement;
                if (!defElement.getElementType().equals(POLICY_QNAME) || (attrValue = XMLHelper.getAttribute((Element)(defDomElement = ((UnknownExtensibilityElement)defElement).getElement()), (String)SECURITY_UTILITY_URI, (String)ATTR_ID)) == null || !attrValue.equals(uri)) continue;
                if (!addressing.booleanValue()) {
                    addressing = WSDLUtil.setAddressingEnabled(feature, defDomElement);
                }
                if (!mtom.booleanValue()) {
                    mtom = WSDLUtil.setMtomEnabled(feature, defDomElement);
                }
                if (!addressing.booleanValue() || !mtom.booleanValue()) continue;
                break block3;
            }
        }
        return feature;
    }

    private static Boolean setAddressingEnabled(Feature feature, Element defDomElement) {
        Element child = XMLHelper.getFirstChildElementByName((Node)defDomElement, (String)ELE_ADDRESSING);
        if (child != null) {
            feature.setAddressingEnabled(true);
            WSDLUtil.setAddressingRequired(feature, child);
            return true;
        }
        child = XMLHelper.getFirstChildElementByName((Node)defDomElement, (String)ELE_EXACTLYONE);
        if (child != null) {
            child = XMLHelper.getFirstChildElementByName((Node)child, (String)ELE_ALL);
            while (child != null) {
                Element addressingEle = XMLHelper.getFirstChildElementByName((Node)child, (String)ELE_ADDRESSING);
                if (addressingEle != null) {
                    feature.setAddressingEnabled(true);
                    WSDLUtil.setAddressingRequired(feature, addressingEle);
                    return true;
                }
                child = XMLHelper.getNextSiblingElementByName((Node)child, (String)ELE_ALL);
            }
        }
        return false;
    }

    private static void setAddressingRequired(Feature feature, Element element) {
        String attrValue = XMLHelper.getAttribute((Element)element, (String)WSDL11_URI, (String)ATTR_REQUIRED);
        if (attrValue != null) {
            feature.setAddressingRequired(Boolean.valueOf(attrValue));
        }
    }

    private static Boolean setMtomEnabled(Feature feature, Element defDomElement) {
        Element child = XMLHelper.getFirstChildElementByName((Node)defDomElement, (String)ELE_MTOM);
        if (child != null) {
            feature.setMtomEnabled(true);
            return true;
        }
        child = XMLHelper.getFirstChildElementByName((Node)defDomElement, (String)ELE_EXACTLYONE);
        if (child != null) {
            child = XMLHelper.getFirstChildElementByName((Node)child, (String)ELE_ALL);
            while (child != null) {
                Element addressingEle = XMLHelper.getFirstChildElementByName((Node)child, (String)ELE_MTOM);
                if (addressingEle != null) {
                    feature.setMtomEnabled(true);
                    return true;
                }
                child = XMLHelper.getNextSiblingElementByName((Node)child, (String)ELE_ALL);
            }
        }
        return false;
    }

    private static Boolean setMtomEnabled(Schema schema) {
        if (schema != null) {
            if (WSDLUtil.hasExpectedContentTypes(schema.getElement()).booleanValue()) {
                return true;
            }
            for (List c : schema.getImports().values()) {
                for (SchemaImport simport : c) {
                    if (!WSDLUtil.setMtomEnabled(simport.getReferencedSchema()).booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static Boolean hasExpectedContentTypes(Element element) {
        if (element != null) {
            if (XMLHelper.hasAttribute((Element)element, (String)WSDL_XMIME_URI, (String)ATTR_EXP_CT).booleanValue()) {
                return true;
            }
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (node.getNodeType() != 1 || !WSDLUtil.hasExpectedContentTypes((Element)node).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static ExchangePattern getExchangePattern(Operation operation) {
        if (operation.getStyle().equals(OperationType.ONE_WAY)) {
            return ExchangePattern.IN_ONLY;
        }
        return ExchangePattern.IN_OUT;
    }
}

