/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.endpoint;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.apache.cxf.ws.addressing.impl.AddressingFeatureApplier;
import org.switchyard.common.type.Classes;
import org.switchyard.component.soap.InboundHandler;
import org.switchyard.component.soap.SOAPLogger;
import org.switchyard.component.soap.endpoint.BaseWebService;
import org.switchyard.component.soap.endpoint.WSEndpoint;

public class CXFJettyEndpoint
implements WSEndpoint {
    private static Bus _bus = BusFactory.newInstance().createBus();
    private JaxWsServerFactoryBean _svrFactory;
    private Server _server;
    private String _publishUrl;

    public CXFJettyEndpoint(String bindingId, InboundHandler handler, WebServiceFeature ... features) {
        BaseWebService wsProvider = new BaseWebService();
        wsProvider.setInvocationClassLoader(Classes.getTCCL());
        wsProvider.setConsumer(handler);
        this._svrFactory = new JaxWsServerFactoryBean();
        this._svrFactory.setServiceClass(BaseWebService.class);
        this._svrFactory.setServiceBean((Object)wsProvider);
        this._svrFactory.setBindingId(bindingId);
        HashMap<String, Boolean> props = new HashMap<String, Boolean>();
        ArrayList<WebServiceFeature> cxfFeatures = new ArrayList<WebServiceFeature>();
        for (WebServiceFeature feature : features) {
            cxfFeatures.add(feature);
            if (feature instanceof AddressingFeature && ((AddressingFeature)feature).isEnabled()) {
                SOAPLogger.ROOT_LOGGER.addressingEnabledRequired(String.valueOf(((AddressingFeature)feature).isEnabled()), String.valueOf(((AddressingFeature)feature).isRequired()));
                continue;
            }
            if (!(feature instanceof MTOMFeature)) continue;
            props.put("mtom-enabled", ((MTOMFeature)feature).isEnabled());
            SOAPLogger.ROOT_LOGGER.mTOMEnabledThreshold(String.valueOf(((MTOMFeature)feature).isEnabled()), String.valueOf(((MTOMFeature)feature).getThreshold()));
        }
        ((JaxWsServiceFactoryBean)this._svrFactory.getServiceFactory()).setWsFeatures(cxfFeatures);
        this._svrFactory.setProperties(props);
        this._svrFactory.getInInterceptors().add(new LoggingInInterceptor());
        this._svrFactory.getInInterceptors().add(new SAAJInInterceptor());
        this._svrFactory.getInInterceptors().add(new SoapActionInInterceptor());
        this._svrFactory.getOutInterceptors().add(new LoggingOutInterceptor());
        this._svrFactory.getOutInterceptors().add(new SAAJOutInterceptor());
    }

    public JaxWsServerFactoryBean getEndpoint() {
        return this._svrFactory;
    }

    public void publish(String publishUrl) {
        this._publishUrl = publishUrl;
        SOAPLogger.ROOT_LOGGER.publishingWebServiceAt(this._publishUrl);
        this._svrFactory.setAddress(publishUrl);
        this._server = this._svrFactory.create();
        this._server.start();
    }

    @Override
    public void stop() {
        SOAPLogger.ROOT_LOGGER.stoppingWebServiceAt(this._publishUrl);
        this._server.stop();
        this._server.destroy();
    }

    static {
        _bus.setExtension((Object)new AddressingFeatureApplier(), WSAddressingFeature.WSAddressingFeatureApplier.class);
    }
}

