/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.composer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.dom.DOMSource;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeState;
import org.switchyard.Message;
import org.switchyard.component.common.composer.BaseMessageComposer;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.soap.composer.SOAPBindingData;
import org.switchyard.component.soap.util.SOAPUtil;
import org.switchyard.component.soap.util.WSDLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPMessageComposer
extends BaseMessageComposer<SOAPBindingData> {
    private static final String DOC_LIT_WRAPPED_REPLY_SUFFIX = "Response";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_ID = "Content-ID";
    private static final String CONTENT_ID_START = "<";
    private static final String CONTENT_DISPOSITION_NAME = "name=";
    private static final String CONTENT_DISPOSITION_QUOTE = "\"";
    private static final String TEMP_FILE_EXTENSION = ".tmp";
    private static Logger _log = Logger.getLogger(SOAPMessageComposer.class);
    private Port _wsdlPort;
    private Boolean _documentStyle = false;
    private Boolean _mtomEnabled = false;
    private Boolean _xopExpand = false;
    private Boolean _unwrapped = false;

    public Message compose(SOAPBindingData source, Exchange exchange) throws Exception {
        SOAPMessage soapMessage = source.getSOAPMessage();
        Message message = exchange.createMessage();
        Boolean input = exchange.getPhase() == null;
        this.getContextMapper().mapFrom((BindingData)source, exchange.getContext(message));
        SOAPEnvelope envelope = soapMessage.getSOAPPart().getEnvelope();
        if (envelope == null) {
            return message;
        }
        SOAPBody soapBody = envelope.getBody();
        if (soapBody == null) {
            throw new SOAPException("Missing SOAP body from request");
        }
        try {
            String opName;
            List<Element> bodyChildren;
            SOAPFault fault;
            if (soapBody.hasFault() && (fault = soapBody.getFault()).hasDetail()) {
                Detail detail = fault.getDetail();
                DetailEntry entry = null;
                Iterator entries = detail.getDetailEntries();
                if (entries.hasNext()) {
                    entry = (DetailEntry)entries.next();
                }
                if (entry != null) {
                    Node detailNode = entry.getParentNode().removeChild((Node)entry);
                    message.setContent((Object)new DOMSource(detailNode));
                    return message;
                }
            }
            if ((bodyChildren = this.getChildElements((Node)soapBody)).size() > 1) {
                throw new SOAPException("Found multiple SOAPElements in SOAPBody");
            }
            if (bodyChildren.size() == 0 || bodyChildren.get(0) == null) {
                throw new SOAPException("Could not find SOAPElement in SOAPBody");
            }
            Node bodyNode = bodyChildren.get(0);
            if (this._documentStyle.booleanValue() && this._unwrapped.booleanValue() && (opName = exchange.getContract().getConsumerOperation().getName()) != null && opName.equals(bodyNode.getLocalName())) {
                List<Element> subChildren = this.getChildElements(bodyNode);
                if (subChildren.size() == 0 || subChildren.size() > 1) {
                    _log.debug((Object)("Unable to unwrap element: " + bodyNode.getLocalName() + ". A single child element is required."));
                } else {
                    bodyNode = subChildren.get(0);
                }
            }
            bodyNode = bodyNode.getParentNode().removeChild(bodyNode);
            HashMap<String, DataSource> attachments = new HashMap<String, DataSource>();
            Iterator aparts = soapMessage.getAttachments();
            while (aparts.hasNext()) {
                AttachmentPart apRequest = (AttachmentPart)aparts.next();
                String[] contentId = apRequest.getMimeHeader(CONTENT_ID);
                String name = null;
                if (this._mtomEnabled.booleanValue()) {
                    if (contentId == null) {
                        throw new SOAPException("Content-ID header missing for attachment part");
                    }
                    name = contentId[0];
                } else {
                    name = apRequest.getDataHandler().getDataSource().getName();
                    if (name == null || name.length() == 0) {
                        String[] disposition = apRequest.getMimeHeader(CONTENT_DISPOSITION);
                        String string = name = contentId != null ? contentId[0] : null;
                        if (name == null && disposition != null) {
                            int start = disposition[0].indexOf(CONTENT_DISPOSITION_NAME);
                            String namePart = disposition[0].substring(start + CONTENT_DISPOSITION_NAME.length() + 1);
                            int end = namePart.indexOf(CONTENT_DISPOSITION_QUOTE);
                            name = namePart.substring(0, end);
                        } else if (name == null) {
                            name = UUID.randomUUID() + TEMP_FILE_EXTENSION;
                        }
                    }
                }
                if (name.startsWith(CONTENT_ID_START)) {
                    name = name.substring(1, name.length() - 1);
                }
                if (this._mtomEnabled.booleanValue() && this._xopExpand.booleanValue()) {
                    attachments.put(name, apRequest.getDataHandler().getDataSource());
                    continue;
                }
                message.addAttachment(name, apRequest.getDataHandler().getDataSource());
            }
            if (this._mtomEnabled.booleanValue() && this._xopExpand.booleanValue()) {
                bodyNode = SOAPUtil.expandXop((Element)bodyNode, attachments);
            }
            message.setContent((Object)new DOMSource(bodyNode));
        }
        catch (Exception ex) {
            if (ex instanceof SOAPException) {
                throw (SOAPException)((Object)ex);
            }
            throw new SOAPException((Throwable)ex);
        }
        return message;
    }

    public SOAPBindingData decompose(Exchange exchange, SOAPBindingData target) throws Exception {
        SOAPMessage soapMessage = target.getSOAPMessage();
        Message message = exchange.getMessage();
        Boolean input = exchange.getPhase() == null;
        if (message != null) {
            if (message.getContent() == null) {
                throw new SOAPException("Unable to create SOAP Body due to null message content");
            }
            if (message.getContent() instanceof SOAPMessage) {
                return new SOAPBindingData((SOAPMessage)message.getContent());
            }
            try {
                Node messageNode = (Node)message.getContent(Node.class);
                if (messageNode != null) {
                    Node messageNodeImport = soapMessage.getSOAPBody().getOwnerDocument().importNode(messageNode, true);
                    if (exchange.getState() != ExchangeState.FAULT || this.isSOAPFaultPayload(messageNode)) {
                        if (this._documentStyle.booleanValue()) {
                            String opName = exchange.getContract().getProviderOperation().getName();
                            if (this._unwrapped.booleanValue()) {
                                String ns = this.getWrapperNamespace(opName, input);
                                if (!messageNodeImport.getLocalName().equals(opName + DOC_LIT_WRAPPED_REPLY_SUFFIX)) {
                                    Element wrapper = messageNodeImport.getOwnerDocument().createElementNS(ns, opName + DOC_LIT_WRAPPED_REPLY_SUFFIX);
                                    wrapper.appendChild(messageNodeImport);
                                    messageNodeImport = wrapper;
                                }
                            }
                        }
                        soapMessage.getSOAPBody().appendChild(messageNodeImport);
                        for (String name : message.getAttachmentMap().keySet()) {
                            AttachmentPart apResponse = soapMessage.createAttachmentPart();
                            apResponse.setDataHandler(new DataHandler(message.getAttachment(name)));
                            apResponse.setContentId(CONTENT_ID_START + name + ">");
                            soapMessage.addAttachmentPart(apResponse);
                        }
                    } else {
                        SOAPUtil.addFault(soapMessage).addDetail().appendChild(messageNodeImport);
                    }
                }
            }
            catch (Exception e) {
                if (exchange.getState().equals((Object)ExchangeState.FAULT) && exchange.getMessage().getContent() instanceof Exception) {
                    throw (Exception)exchange.getMessage().getContent(Exception.class);
                }
                throw new SOAPException("Unable to parse SOAP Message", (Throwable)e);
            }
        }
        try {
            this.getContextMapper().mapTo(exchange.getContext(), (BindingData)target);
        }
        catch (Exception ex) {
            throw new SOAPException("Failed to map context properties to SOAP message", (Throwable)ex);
        }
        return target;
    }

    private boolean isSOAPFaultPayload(Node messageNode) {
        String nsURI;
        String rootName = messageNode.getLocalName().toLowerCase();
        return rootName.equals("fault") && ((nsURI = messageNode.getNamespaceURI()).equals("http://www.w3.org/2003/05/soap-envelope") || nsURI.equals("http://schemas.xmlsoap.org/soap/envelope/"));
    }

    private List<Element> getChildElements(Node parent) {
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() != 1) continue;
            children.add((Element)nodes.item(i));
        }
        return children;
    }

    private String getWrapperNamespace(String operationName, boolean input) {
        String ns = null;
        if (this._wsdlPort != null) {
            Operation operation = WSDLUtil.getOperationByName(this._wsdlPort, operationName);
            if (!this._documentStyle.booleanValue()) {
                ns = input ? operation.getInput().getMessage().getQName().getNamespaceURI() : operation.getOutput().getMessage().getQName().getNamespaceURI();
            } else {
                Part part;
                Part part2 = part = input ? (Part)operation.getInput().getMessage().getParts().values().iterator().next() : (Part)operation.getOutput().getMessage().getParts().values().iterator().next();
                if (part.getElementName() != null) {
                    ns = part.getElementName().getNamespaceURI();
                } else if (part.getTypeName() != null) {
                    ns = part.getTypeName().getNamespaceURI();
                }
            }
        }
        return ns;
    }

    public Port getWsdlPort() {
        return this._wsdlPort;
    }

    public void setWsdlPort(Port wsdlPort) {
        this._wsdlPort = wsdlPort;
    }

    public Boolean isDocumentStyle() {
        return this._documentStyle;
    }

    public void setDocumentStyle(Boolean style) {
        this._documentStyle = style;
    }

    public Boolean isMtomEnabled() {
        return this._mtomEnabled;
    }

    public void setMtomEnabled(Boolean enabled) {
        this._mtomEnabled = enabled;
    }

    public Boolean isXopExpand() {
        return this._xopExpand;
    }

    public void setXopExpand(Boolean expand) {
        this._xopExpand = expand;
    }

    public Boolean isUnwrapped() {
        return this._unwrapped;
    }

    public void setUnwrapped(Boolean unwrapped) {
        this._unwrapped = unwrapped;
    }
}

