/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.endpoint;

import java.net.MalformedURLException;
import java.util.HashMap;
import javax.xml.ws.WebServiceFeature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.switchyard.ServiceDomain;
import org.switchyard.component.common.Endpoint;
import org.switchyard.component.soap.AddressingInterceptor;
import org.switchyard.component.soap.InboundHandler;
import org.switchyard.component.soap.WebServicePublishException;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.endpoint.AbstractEndpointPublisher;
import org.switchyard.component.soap.endpoint.CXFJettyEndpoint;

public class CXFJettyEndpointPublisher
extends AbstractEndpointPublisher {
    private static final String HTTP_SCHEME = "http";

    @Override
    public synchronized Endpoint publish(ServiceDomain domain, SOAPBindingModel config, String bindingId, InboundHandler handler, WebServiceFeature ... features) {
        CXFJettyEndpoint wsEndpoint = null;
        try {
            this.initialize(config);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("javax.xml.ws.wsdl.service", config.getPort().getServiceQName());
            properties.put("javax.xml.ws.wsdl.port", config.getPort().getPortQName());
            properties.put("javax.xml.ws.wsdl.description", this.getWsdlLocation());
            String publishUrl = "http://" + config.getSocketAddr().getHost() + ":" + config.getSocketAddr().getPort() + "/" + this.getContextPath();
            wsEndpoint = new CXFJettyEndpoint(bindingId, config, handler, (Interceptor<? extends Message>)new AddressingInterceptor(), features);
            wsEndpoint.getEndpoint().setWsdlURL(this.getWsdlLocation());
            wsEndpoint.getEndpoint().setServiceName(config.getPort().getServiceQName());
            wsEndpoint.publish(publishUrl);
        }
        catch (MalformedURLException e) {
            throw new WebServicePublishException(e);
        }
        return wsEndpoint;
    }
}

