/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.composer;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.common.io.pull.ElementPuller;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.common.composer.BaseRegexContextMapper;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.label.ComponentLabel;
import org.switchyard.component.common.label.EndpointLabel;
import org.switchyard.component.soap.composer.SOAPBindingData;
import org.switchyard.component.soap.composer.SOAPHeadersType;
import org.switchyard.config.Configuration;
import org.switchyard.config.ConfigurationPuller;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPContextMapper
extends BaseRegexContextMapper<SOAPBindingData> {
    public static final String HTTP_RESPONSE_STATUS = "http_response_status";
    public static final List<String> HTTP_HEADERS_EXCLUDED = Arrays.asList("content-type", "content-length");
    private static final String[] SOAP_HEADER_LABELS = new String[]{ComponentLabel.SOAP.label(), EndpointLabel.SOAP.label()};
    private static final String[] SOAP_MIME_LABELS = new String[]{ComponentLabel.SOAP.label(), EndpointLabel.HTTP.label()};
    private static final String HEADER_NAMESPACE_PROPAGATION = "org.switchyard.propagate.property";
    private SOAPHeadersType _soapHeadersType = null;

    public SOAPHeadersType getSOAPHeadersType() {
        return this._soapHeadersType;
    }

    public SOAPContextMapper setSOAPHeadersType(SOAPHeadersType soapHeadersType) {
        this._soapHeadersType = soapHeadersType;
        return this;
    }

    public void mapFrom(SOAPBindingData source, Context context) throws Exception {
        super.mapFrom((BindingData)source, context);
        SOAPMessage soapMessage = source.getSOAPMessage();
        if (soapMessage.getSOAPBody().hasFault() && source.getSOAPFaultInfo() != null) {
            context.setProperty("soap_fault_info", (Object)source.getSOAPFaultInfo(), Scope.EXCHANGE).addLabels(SOAP_HEADER_LABELS);
        }
        if (source.getStatus() != null) {
            context.setProperty(HTTP_RESPONSE_STATUS, (Object)source.getStatus()).addLabels(SOAP_MIME_LABELS);
        }
        for (String key : source.getHttpHeaders().keySet()) {
            List<String> values;
            if (!this.matches(key) || (values = source.getHttpHeaders().get(key)) == null) continue;
            if (values.size() == 1) {
                context.setProperty(key, (Object)values.get(0)).addLabels(SOAP_MIME_LABELS);
            } else {
                context.setProperty(key, values).addLabels(SOAP_MIME_LABELS);
            }
            this.copyHttpHeadersToContext(context, key, values);
        }
        Iterator soapHeaders = soapMessage.getSOAPHeader().examineAllHeaderElements();
        while (soapHeaders.hasNext()) {
            Object value;
            SOAPHeaderElement soapHeader = (SOAPHeaderElement)soapHeaders.next();
            QName qname = soapHeader.getElementQName();
            if (!this.matches(qname)) continue;
            switch (this._soapHeadersType != null ? this._soapHeadersType : SOAPHeadersType.VALUE) {
                case CONFIG: {
                    value = new ConfigurationPuller().pull((Element)soapHeader);
                    break;
                }
                case DOM: {
                    value = soapHeader;
                    break;
                }
                case VALUE: {
                    value = soapHeader.getValue();
                    break;
                }
                case XML: {
                    value = new ConfigurationPuller().pull((Element)soapHeader).toString();
                    break;
                }
                default: {
                    value = null;
                }
            }
            if (value == null) continue;
            String name = qname.toString();
            context.setProperty(name, value).addLabels(SOAP_HEADER_LABELS);
            this.copySOAPHeadersToContext(context, qname.getLocalPart(), value);
        }
    }

    public void mapTo(Context context, SOAPBindingData target) throws Exception {
        super.mapTo(context, (BindingData)target);
        SOAPMessage soapMessage = target.getSOAPMessage();
        SOAPHeader soapHeader = soapMessage.getSOAPHeader();
        for (Property property : context.getProperties()) {
            boolean qualifiedForSoapHeader;
            Object value = property.getValue();
            if (value == null) continue;
            String name = property.getName();
            QName qname = XMLHelper.createQName((String)name);
            boolean bl = qualifiedForSoapHeader = Strings.trimToNull((String)qname.getNamespaceURI()) != null;
            if (qualifiedForSoapHeader && this.matches(qname)) {
                if (value instanceof Node) {
                    Node domNode = soapHeader.getOwnerDocument().importNode((Node)value, true);
                    soapHeader.appendChild(domNode);
                    continue;
                }
                if (value instanceof Configuration) {
                    Element configElement = new ElementPuller().pull((Reader)new StringReader(value.toString()));
                    Node configNode = soapHeader.getOwnerDocument().importNode(configElement, true);
                    soapHeader.appendChild(configNode);
                    continue;
                }
                String v = value.toString();
                if (SOAPHeadersType.XML.equals((Object)this._soapHeadersType)) {
                    try {
                        Element xmlElement = new ElementPuller().pull((Reader)new StringReader(v));
                        Node xmlNode = soapHeader.getOwnerDocument().importNode(xmlElement, true);
                        soapHeader.appendChild(xmlNode);
                    }
                    catch (Throwable t) {
                        soapHeader.addChildElement(qname).setValue(v);
                    }
                    continue;
                }
                soapHeader.addChildElement(qname).setValue(v);
                continue;
            }
            if (this.matches(name) || property.hasLabel(EndpointLabel.HTTP.label())) {
                if (HTTP_RESPONSE_STATUS.equalsIgnoreCase(name)) {
                    if (value instanceof String) {
                        target.setStatus(Integer.parseInt((String)value));
                        continue;
                    }
                    if (!(value instanceof Integer)) continue;
                    target.setStatus((Integer)value);
                    continue;
                }
                if (HTTP_HEADERS_EXCLUDED.contains(name.toLowerCase())) continue;
                if (value instanceof List) {
                    ArrayList<String> stringValues = new ArrayList<String>();
                    for (Object v : (List)List.class.cast(value)) {
                        if (v != null && !(v instanceof String)) continue;
                        stringValues.add((String)v);
                    }
                    if (stringValues.isEmpty()) continue;
                    target.getHttpHeaders().put(name, stringValues);
                    continue;
                }
                if (!(value instanceof String)) continue;
                target.getHttpHeaders().put(name, Collections.singletonList((String)value));
                continue;
            }
            this.copyToSOAPHeader(soapHeader, property);
        }
    }

    private void copyHttpHeadersToContext(Context context, String name, List<String> values) {
        if (values.size() == 1) {
            context.setProperty(name, (Object)values.get(0), Scope.EXCHANGE).addLabels(SOAP_MIME_LABELS);
        } else {
            context.setProperty(name, values, Scope.EXCHANGE).addLabels(SOAP_MIME_LABELS);
        }
    }

    private void copySOAPHeadersToContext(Context context, String name, Object value) {
        if (this.matches(name, this.getIncludeRegexes(), new ArrayList())) {
            context.setProperty(name, value, Scope.EXCHANGE).addLabels(SOAP_HEADER_LABELS);
        }
    }

    private void copyToSOAPHeader(SOAPHeader soapHeader, Property property) throws IOException, SOAPException {
        if (property != null && this.matches(property.getName(), this.getIncludeRegexes(), new ArrayList())) {
            String v = property.getValue().toString();
            QName qname = new QName(HEADER_NAMESPACE_PROPAGATION, property.getName());
            if (SOAPHeadersType.XML.equals((Object)this._soapHeadersType)) {
                try {
                    Element xmlElement = new ElementPuller().pull((Reader)new StringReader(v));
                    Node xmlNode = soapHeader.getOwnerDocument().importNode(xmlElement, true);
                    soapHeader.appendChild(xmlNode);
                }
                catch (Throwable t) {
                    soapHeader.addChildElement(qname).setValue(v);
                }
            } else {
                soapHeader.addChildElement(qname).setValue(v);
            }
        }
    }
}

