/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import javax.xml.soap.SOAPHeaderElement;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.apache.cxf.ws.addressing.soap.MAPCodec;
import org.switchyard.Context;
import org.switchyard.component.soap.util.SOAPUtil;

public class AddressingInterceptor
extends AbstractSoapInterceptor {
    public AddressingInterceptor() {
        super("pre-protocol");
        this.addAfter(WebFaultOutInterceptor.class.getName());
        this.addBefore(MAPCodec.class.getName());
    }

    public void handleMessage(SoapMessage message) throws Fault {
        if (ContextUtils.isOutbound((Message)message)) {
            AddressingProperties maps = ContextUtils.retrieveMAPs((Message)message, (boolean)false, (boolean)true, (boolean)false);
            WrappedMessageContext soapContext = new WrappedMessageContext((Message)message, MessageContext.Scope.APPLICATION);
            if (soapContext.containsKey((Object)"SWITCHYARD_CONTEXT")) {
                Context context = (Context)soapContext.get((Object)"SWITCHYARD_CONTEXT");
                String property = this.getContextProperty(context, SOAPUtil.WSA_ACTION_STR);
                AttributedURIType uri = null;
                EndpointReferenceType ref = null;
                if (property != null) {
                    uri = new AttributedURIType();
                    uri.setValue(property);
                    maps.setAction(uri);
                }
                if ((property = this.getContextProperty(context, SOAPUtil.WSA_FROM_STR)) != null) {
                    uri = new AttributedURIType();
                    uri.setValue(property);
                    ref = new EndpointReferenceType();
                    ref.setAddress(uri);
                    maps.setFrom(ref);
                }
                if ((property = this.getContextProperty(context, SOAPUtil.WSA_TO_STR)) != null) {
                    uri = new AttributedURIType();
                    uri.setValue(property);
                    ref = new EndpointReferenceType();
                    ref.setAddress(uri);
                    maps.setTo(ref);
                }
                if ((property = this.getContextProperty(context, SOAPUtil.WSA_FAULTTO_STR)) != null) {
                    uri = new AttributedURIType();
                    uri.setValue(property);
                    ref = new EndpointReferenceType();
                    ref.setAddress(uri);
                    maps.setFaultTo(ref);
                }
                if ((property = this.getContextProperty(context, SOAPUtil.WSA_REPLYTO_STR)) != null) {
                    uri = new AttributedURIType();
                    uri.setValue(property);
                    ref = new EndpointReferenceType();
                    ref.setAddress(uri);
                    maps.setReplyTo(ref);
                }
                if ((property = this.getContextProperty(context, SOAPUtil.WSA_RELATESTO_STR)) != null) {
                    RelatesToType relatesTo = new RelatesToType();
                    relatesTo.setValue(property);
                    maps.setRelatesTo(relatesTo);
                }
                if ((property = this.getContextProperty(context, SOAPUtil.WSA_MESSAGEID_STR)) != null) {
                    uri = new AttributedURIType();
                    uri.setValue(property);
                    maps.setMessageID(uri);
                }
            }
        }
    }

    private String getContextProperty(Context context, String name) {
        Object p = context.getPropertyValue(name);
        if (p instanceof SOAPHeaderElement) {
            return ((SOAPHeaderElement)p).getValue();
        }
        if (p != null) {
            return p.toString();
        }
        return null;
    }
}

