/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.soap.SOAPFaultException;
import org.jboss.logging.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.component.common.DeliveryException;
import org.switchyard.component.common.Endpoint;
import org.switchyard.component.common.SynchronousInOutHandler;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.soap.Feature;
import org.switchyard.component.soap.PortName;
import org.switchyard.component.soap.SOAPLogger;
import org.switchyard.component.soap.SOAPMessages;
import org.switchyard.component.soap.WebServicePublishException;
import org.switchyard.component.soap.composer.SOAPBindingData;
import org.switchyard.component.soap.composer.SOAPComposition;
import org.switchyard.component.soap.composer.SOAPMessageComposer;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.endpoint.EndpointPublisherFactory;
import org.switchyard.component.soap.util.SOAPUtil;
import org.switchyard.component.soap.util.WSDLUtil;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.security.context.SecurityContext;
import org.switchyard.security.context.SecurityContextManager;
import org.switchyard.security.credential.Credential;
import org.w3c.dom.Node;

public class InboundHandler
extends BaseServiceHandler {
    private static final Logger LOGGER = Logger.getLogger(InboundHandler.class);
    private static final long DEFAULT_TIMEOUT = 15000L;
    private static final String MESSAGE_NAME = "org.switchyard.soap.messageName";
    private final SOAPBindingModel _config;
    private final String _gatewayName;
    private MessageComposer<SOAPBindingData> _messageComposer;
    private SecurityContextManager _securityContextManager;
    private ServiceDomain _domain;
    private ServiceReference _service;
    private long _waitTimeout = 15000L;
    private Endpoint _endpoint;
    private Port _wsdlPort;
    private String _bindingId;
    private Boolean _documentStyle = false;
    private Boolean _unwrapped = false;
    private String _targetNamespace;
    private Feature _feature = new Feature();
    private Map<String, Operation> _operationsMap = new HashMap<String, Operation>();
    private Map<String, String> _faultsMap = new HashMap<String, String>();
    private static final ThreadLocal<Set<Credential>> CREDENTIALS = new ThreadLocal();

    public static Set<Credential> getCredentials() {
        return InboundHandler.getCredentials(false);
    }

    private static Set<Credential> getCredentials(boolean unset) {
        Set<Credential> credentials = CREDENTIALS.get();
        if (credentials == null) {
            credentials = new LinkedHashSet<Credential>();
            if (!unset) {
                CREDENTIALS.set(credentials);
            }
        }
        if (unset) {
            CREDENTIALS.set(null);
        }
        return credentials;
    }

    public static void unsetCredentials() {
        CREDENTIALS.set(null);
    }

    public InboundHandler(SOAPBindingModel config, ServiceDomain domain) {
        super(domain);
        this._config = config;
        this._gatewayName = config.getName();
        this._domain = domain;
        this._securityContextManager = new SecurityContextManager(this._domain);
    }

    protected void doStart() throws WebServicePublishException {
        try {
            this._service = this._domain.getServiceReference(this._config.getServiceName());
            PortName portName = this._config.getPort();
            Definition definition = WSDLUtil.readWSDL(this._config.getWsdl());
            WSDLUtil.filterWSDL(definition, this._config.getModelConfiguration().getPropertyResolver());
            this._targetNamespace = definition.getTargetNamespace();
            Service wsdlService = WSDLUtil.getService(definition, portName);
            this._wsdlPort = WSDLUtil.getPort(wsdlService, portName);
            portName.setServiceQName(wsdlService.getQName());
            portName.setName(this._wsdlPort.getName());
            String style = WSDLUtil.getStyle(this._wsdlPort);
            this._documentStyle = style.equals("document");
            this._unwrapped = this._config.isUnwrapped();
            this._feature = WSDLUtil.getFeature(definition, this._wsdlPort, this._documentStyle);
            if (this._feature.isAddressingEnabled().booleanValue()) {
                List bindingOperations = this._wsdlPort.getBinding().getBindingOperations();
                for (BindingOperation bindingOp : bindingOperations) {
                    String inputAction = WSDLUtil.getInputAction(this._wsdlPort, new QName(this._targetNamespace, bindingOp.getOperation().getName()), this._documentStyle);
                    this._operationsMap.put(inputAction, bindingOp.getOperation());
                    for (Fault fault : bindingOp.getOperation().getFaults().values()) {
                        String faultAction = WSDLUtil.getFaultAction(fault, this._wsdlPort, new QName(this._targetNamespace, bindingOp.getOperation().getName()));
                        this._faultsMap.put(fault.getName(), faultAction);
                    }
                }
            }
            MTOMFeature mtom = this._feature.getMtom(this._config);
            this._bindingId = WSDLUtil.getBindingId(this._wsdlPort, mtom.isEnabled());
            this._endpoint = EndpointPublisherFactory.getEndpointPublisher().publish(this._domain, this._config, this._bindingId, this, new WebServiceFeature[]{this._feature.getAddressing(), mtom});
            this._messageComposer = SOAPComposition.getMessageComposer(this._config);
            ((SOAPMessageComposer)this._messageComposer).setDocumentStyle(this._documentStyle);
            ((SOAPMessageComposer)this._messageComposer).setWsdlPort(this._wsdlPort);
            ((SOAPMessageComposer)this._messageComposer).setMtomEnabled(mtom.isEnabled());
            ((SOAPMessageComposer)this._messageComposer).setUnwrapped(this._unwrapped);
            if (this._config.getMtomConfig() != null) {
                ((SOAPMessageComposer)this._messageComposer).setXopExpand(this._config.getMtomConfig().isXopExpand());
            }
        }
        catch (WSDLException e) {
            throw new WebServicePublishException(e);
        }
    }

    protected void doStop() {
        if (this._endpoint != null) {
            this._endpoint.stop();
        }
        SOAPLogger.ROOT_LOGGER.webService(this._config.getPort().toString());
    }

    public void handleFault(Exchange exchange) {
        throw SOAPMessages.MESSAGES.unexpected();
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        throw SOAPMessages.MESSAGES.unexpected();
    }

    public SOAPMessage invoke(SOAPMessage soapMessage) {
        return this.invoke(soapMessage, null);
    }

    public SOAPMessage invoke(SOAPMessage soapMessage, WebServiceContext wsContext) {
        Operation operation;
        String operationName = null;
        Boolean oneWay = false;
        QName firstBodyElement = null;
        MessageContext msgContext = null;
        Set<Credential> credentials = InboundHandler.getCredentials(true);
        if (wsContext != null) {
            msgContext = wsContext.getMessageContext();
        }
        if (soapMessage == null || soapMessage.getSOAPPart() == null) {
            return this.handleException(soapMessage, oneWay, SOAPMessages.MESSAGES.noSuchOperation(this._wsdlPort.getName().toString()));
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Inbound <-- Request:[" + this._service.getName() + "][" + SOAPUtil.soapMessageToString(soapMessage) + "]"));
        }
        try {
            String action = SOAPUtil.getAddressingAction(soapMessage);
            if (this._feature.isAddressingEnabled().booleanValue() && action != null) {
                operation = this._operationsMap.get(action);
                if (operation == null) {
                    return this.handleException(soapMessage, oneWay, SOAPMessages.MESSAGES.couldNotFindOperation(action));
                }
            } else {
                firstBodyElement = SOAPUtil.getFirstBodyElement(soapMessage);
                operation = WSDLUtil.getOperationByElement(this._wsdlPort, firstBodyElement, this._documentStyle);
            }
            if (operation != null) {
                operationName = operation.getName();
                oneWay = WSDLUtil.isOneWay(operation);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Received SOAP message targeted at Webservice operation '" + operationName + "' on port '" + this._wsdlPort.getName() + "'."));
                }
            }
        }
        catch (SOAPException e) {
            LOGGER.error((Object)e);
            return null;
        }
        if (operation == null) {
            return this.handleException(soapMessage, oneWay, SOAPMessages.MESSAGES.operationNotAvailableTarget(firstBodyElement.toString(), this._service.getName() + "'."));
        }
        try {
            Message message;
            String encoding;
            HttpServletRequest servletRequest;
            SynchronousInOutHandler inOutHandler = new SynchronousInOutHandler();
            Exchange exchange = this._service.createExchange(operationName, (ExchangeHandler)inOutHandler);
            exchange.getContext().setProperty("org.switchyard.exchangeGatewayName", (Object)this._gatewayName, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
            if (msgContext != null && (servletRequest = (HttpServletRequest)msgContext.get((Object)"javax.xml.ws.servlet.request")) != null && (encoding = servletRequest.getCharacterEncoding()) != null) {
                exchange.getContext().setProperty("CamelCharsetName", (Object)encoding, Scope.EXCHANGE);
            }
            SOAPBindingData soapBindingData = new SOAPBindingData(soapMessage, wsContext);
            SecurityContext securityContext = this._securityContextManager.getContext(exchange);
            securityContext.getCredentials().addAll(credentials);
            securityContext.getCredentials().addAll(soapBindingData.extractCredentials());
            this._securityContextManager.setContext(exchange, securityContext);
            if (msgContext != null) {
                Map httpHeaders = (Map)msgContext.get((Object)"javax.xml.ws.http.request.headers");
                soapBindingData.setHttpHeaders(httpHeaders);
            }
            try {
                message = this._messageComposer.compose((BindingData)soapBindingData, exchange);
            }
            catch (Exception e) {
                throw e instanceof SOAPException ? (SOAPException)((Object)e) : new SOAPException((Throwable)e);
            }
            if (!this._unwrapped.booleanValue()) {
                this.assertComposedMessageOK(message, operation);
            }
            exchange.getContext(message).setProperty(MESSAGE_NAME, (Object)operation.getInput().getMessage().getQName().getLocalPart());
            if (oneWay.booleanValue()) {
                exchange.send(message);
                if (exchange.getState().equals((Object)ExchangeState.FAULT)) {
                    return this.composeResponse(exchange, msgContext, operation, true);
                }
                return null;
            }
            exchange.send(message);
            try {
                exchange = inOutHandler.waitForOut(this._waitTimeout);
            }
            catch (DeliveryException e) {
                return this.handleException(soapMessage, oneWay, SOAPMessages.MESSAGES.timedOut(String.valueOf(this._waitTimeout), this._service.getName().toString()));
            }
            if (SOAPUtil.getFactory(this._bindingId) == null) {
                throw SOAPMessages.MESSAGES.failedToInstantiateSOAPMessageFactory();
            }
            if (msgContext != null) {
                msgContext.put((Object)"SWITCHYARD_CONTEXT", (Object)exchange.getContext());
            }
            return this.composeResponse(exchange, msgContext, operation, false);
        }
        catch (SOAPException se) {
            if (msgContext != null) {
                msgContext.put((Object)"javax.xml.ws.http.response.code", (Object)SOAPUtil.DEFAULT_FAULT_RESONSE_CODE);
            }
            return this.handleException(soapMessage, oneWay, se);
        }
    }

    private SOAPMessage composeResponse(Exchange exchange, MessageContext msgContext, Operation operation, Boolean oneWay) throws SOAPException {
        SOAPMessage soapResponse;
        SOAPBindingData bindingData = new SOAPBindingData(SOAPUtil.createMessage(this._bindingId));
        try {
            soapResponse = ((SOAPBindingData)this._messageComposer.decompose(exchange, (BindingData)bindingData)).getSOAPMessage();
            if (msgContext != null && bindingData.getStatus() != null) {
                msgContext.put((Object)"javax.xml.ws.http.response.code", (Object)bindingData.getStatus());
            }
            if (msgContext != null) {
                Map httpHeaders = (Map)msgContext.get((Object)"javax.xml.ws.http.response.headers");
                if (httpHeaders == null) {
                    msgContext.put((Object)"javax.xml.ws.http.response.headers", bindingData.getHttpHeaders());
                } else {
                    httpHeaders.putAll(bindingData.getHttpHeaders());
                }
            }
        }
        catch (SOAPException soapEx) {
            throw soapEx;
        }
        catch (Exception ex) {
            SOAPFaultException sfe;
            String faultAction = this._faultsMap.get(ex.getClass().getSimpleName());
            if (faultAction != null && msgContext != null) {
                msgContext.put((Object)SOAPUtil.WSA_ACTION_STR, (Object)faultAction);
            }
            if ((sfe = this.extractSOAPFaultException(ex)) == null) {
                sfe = new SOAPFaultException(SOAPUtil.createFault((Throwable)ex, this._bindingId, WSDLUtil.getFaultQName(operation, ex.getClass().getSimpleName())));
            }
            throw sfe;
        }
        if (exchange.getState() == ExchangeState.FAULT && soapResponse.getSOAPBody().getFault() == null) {
            return this.handleException(soapResponse, oneWay, SOAPMessages.MESSAGES.invalidResponseConstruction(this._messageComposer.getClass().getName()));
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Inbound --> Response:[" + this._service.getName() + "][" + SOAPUtil.soapMessageToString(soapResponse) + "]"));
        }
        return soapResponse;
    }

    private SOAPFaultException extractSOAPFaultException(Throwable ex) {
        SOAPLogger.ROOT_LOGGER.searchingRecursively(SOAPFaultException.class.getName(), ex == null ? null : ex.getClass().getName());
        if (ex == null) {
            return null;
        }
        if (ex instanceof SOAPFaultException) {
            SOAPLogger.ROOT_LOGGER.instanceOfSoapFaultException(SOAPFaultException.class.getName());
            return (SOAPFaultException)ex;
        }
        if (ex.getCause() != null) {
            if (!ex.equals(ex.getCause())) {
                return this.extractSOAPFaultException(ex.getCause());
            }
            SOAPLogger.ROOT_LOGGER.breakSearchingForClass(SOAPFaultException.class.getName());
        }
        SOAPLogger.ROOT_LOGGER.reachedEndOfExceptionCause(SOAPFaultException.class.getName());
        return null;
    }

    private void assertComposedMessageOK(Message soapMessage, Operation operation) throws SOAPException {
        Node inputMessage = (Node)soapMessage.getContent(Node.class);
        String actualNS = inputMessage.getNamespaceURI();
        String actualLN = inputMessage.getLocalName();
        List parts = operation.getInput().getMessage().getOrderedParts(null);
        if (parts.isEmpty()) {
            throw SOAPMessages.MESSAGES.invalidInputSOAPPayloadForServiceOperation(operation.getName(), this._service.getName().toString(), actualLN);
        }
        QName expectedPayloadType = null;
        if (this._documentStyle.booleanValue()) {
            if (((Part)parts.get(0)).getElementName() != null) {
                expectedPayloadType = ((Part)parts.get(0)).getElementName();
            } else if (((Part)parts.get(0)).getTypeName() != null) {
                expectedPayloadType = ((Part)parts.get(0)).getTypeName();
            }
        } else {
            expectedPayloadType = new QName(this._targetNamespace, operation.getName());
        }
        String expectedNS = null;
        String expectedLN = null;
        if (expectedPayloadType != null) {
            expectedNS = expectedPayloadType.getNamespaceURI();
            expectedLN = expectedPayloadType.getLocalPart();
        }
        if (!this._documentStyle.booleanValue()) {
            expectedLN = operation.getName();
        }
        if (expectedNS != null && !expectedNS.equals(actualNS)) {
            throw SOAPMessages.MESSAGES.invalidInputSOAPPayloadNamespaceForServiceOperation(operation.getName(), this._service.getName().toString(), expectedNS, actualNS);
        }
        if (expectedLN != null && !expectedLN.equals(actualLN)) {
            throw SOAPMessages.MESSAGES.invalidInputSOAPPayloadLocalNamePartForServiceOperation(operation.getName(), this._service.getName().toString(), expectedLN, actualLN);
        }
    }

    private SOAPMessage handleException(SOAPMessage soapRequest, Boolean oneWay, SOAPException se) {
        if (oneWay.booleanValue()) {
            LOGGER.error((Object)se);
        } else {
            try {
                return SOAPUtil.generateFault((Throwable)se, this._bindingId, soapRequest);
            }
            catch (SOAPException e) {
                LOGGER.error((Object)e);
            }
        }
        return null;
    }
}

