/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.test.mixins.activemq;

import java.io.File;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.test.mixins.AbstractTestMixIn;

public class ActiveMQMixIn
extends AbstractTestMixIn {
    private String _config;
    private String _url = "failover://tcp://localhost:61616";
    private String _user = ActiveMQConnectionFactory.DEFAULT_USER;
    private String _passwd = ActiveMQConnectionFactory.DEFAULT_PASSWORD;
    private BrokerService _broker;
    private Connection _connection;

    public ActiveMQMixIn() {
        this(null);
    }

    public ActiveMQMixIn(String config) {
        this._config = config;
    }

    public void initialize() {
        super.initialize();
        try {
            if (this._config == null) {
                this._broker = new BrokerService();
                this._broker.setStartAsync(true);
                this._broker.setBrokerName("default");
                this._broker.setUseJmx(false);
                this._broker.setPersistent(false);
                this._broker.setDataDirectoryFile(new File(System.getProperty("java.io.tmpdir"), "activemq-data"));
                this._broker.addConnector("tcp://localhost:61616");
                this._broker.setUseShutdownHook(false);
            } else {
                this._broker = BrokerFactory.createBroker((String)this._config);
            }
            this._broker.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ActiveMQMixIn setUser(String user) {
        this._user = user;
        return this;
    }

    public ActiveMQMixIn setPassword(String passwd) {
        this._passwd = passwd;
        return this;
    }

    public ActiveMQMixIn setConfig(String config) {
        this._config = config;
        return this;
    }

    public void uninitialize() {
        try {
            if (this._connection != null) {
                this._connection.close();
            }
            if (this._broker != null) {
                this._broker.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            super.uninitialize();
        }
    }

    public Session getSession() {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this._url);
        try {
            if (this._connection == null) {
                this._connection = connectionFactory.createConnection(this._user, this._passwd);
                this._connection.start();
            }
            return this._connection.createSession(false, 1);
        }
        catch (JMSException e) {
            throw new SwitchYardException((Throwable)e);
        }
    }
}

