/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test.mixins.amqp;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.qpid.client.AMQConnectionFactory;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.server.Broker;
import org.apache.qpid.server.BrokerOptions;
import org.switchyard.SwitchYardException;
import org.switchyard.component.test.mixins.naming.NamingMixIn;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.test.MixInDependencies;
import org.switchyard.test.mixins.AbstractTestMixIn;

@MixInDependencies(required={NamingMixIn.class})
public class AMQPMixIn
extends AbstractTestMixIn {
    public static final String JNDI_CONNECTION_FACTORY = "java:jboss/qpidConnectionFactory";
    public static final String DEFAULT_QUEUE_JNDI_LOCATION = "java:jboss/queueExchange";
    public static final String DEFAULT_TOPIC_JNDI_LOCATION = "java:jboss/topicExchange";
    private static final String AMQP_PROPERTIES_FILE = "/amqp.properties";
    private static final String LOG_XML = "/log4j.xml";
    private static final String CONFIG_XML = "/config.xml";
    private static final String QPID_WORK_DIRECTORY = "/qpid";
    private static final String SYS_PROP_QPID_HOME = "QPID_HOME";
    private static final String SYS_PROP_QPID_WORK = "QPID_WORK";
    protected static final String AMQP_PROPS_QPID_CONNECTIONFACTORY = "qpidConnectionfactory";
    protected static final String AMQP_PROPS_QUEUE_EXCHANGE = "queueExchange";
    protected static final String AMPQ_PROPS_TOPIC_EXCHANGE = "topicExchange";
    private Broker _broker;
    private Properties _properties = new Properties();
    private String _qpidConnectionFactory;
    private String _qpidQueueExchange;
    private String _qpidTopicExchange;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMQPMixIn() throws Exception {
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(AMQP_PROPERTIES_FILE);){
            this._properties.load(is);
            this._qpidConnectionFactory = this._properties.getProperty(AMQP_PROPS_QPID_CONNECTIONFACTORY);
        }
        if (this._qpidConnectionFactory == null) {
            throw new SwitchYardException("No connection factory configured. Please set qpidConnectionfactory in the /amqp.properties file found in the class path of your application");
        }
        this._qpidQueueExchange = this._properties.getProperty(AMQP_PROPS_QUEUE_EXCHANGE);
        this._qpidTopicExchange = this._properties.getProperty(AMPQ_PROPS_TOPIC_EXCHANGE);
        if (this._qpidQueueExchange == null && this._qpidTopicExchange == null) {
            throw new SwitchYardException("No topic or queue configured. Please set either one by using queueExchange or topicExchange in your /amqp.properties properties file.");
        }
    }

    public ConnectionFactory getConnectionFactory() throws NamingException {
        return (ConnectionFactory)new InitialContext().lookup(JNDI_CONNECTION_FACTORY);
    }

    public Destination getDestination(String destinationName) throws NamingException {
        return (Destination)new InitialContext().lookup(destinationName);
    }

    public void before(AbstractDeployment deployment) {
        super.before(deployment);
    }

    public void after(AbstractDeployment deployment) {
        super.after(deployment);
    }

    public void initialize() {
        File file = new File(((Object)((Object)this)).getClass().getResource("/").getFile());
        System.setProperty(SYS_PROP_QPID_HOME, file.getPath());
        System.setProperty(SYS_PROP_QPID_WORK, file.getParent() + QPID_WORK_DIRECTORY);
        BrokerOptions options = new BrokerOptions();
        String configFile = ((Object)((Object)this)).getClass().getResource(CONFIG_XML).getFile();
        options.setConfigFile(configFile);
        URL log4j = ((Object)((Object)this)).getClass().getResource(LOG_XML);
        if (log4j != null) {
            options.setLogConfigFile(log4j.getFile());
        }
        this._broker = new Broker();
        try {
            this._broker.startup(options);
            InitialContext context = new InitialContext();
            context.bind(JNDI_CONNECTION_FACTORY, (Object)new AMQConnectionFactory(this._qpidConnectionFactory));
            if (this._qpidQueueExchange != null) {
                context.bind(DEFAULT_QUEUE_JNDI_LOCATION, (Object)AMQDestination.createDestination((String)this._qpidQueueExchange));
            }
            if (this._qpidTopicExchange != null) {
                context.bind(DEFAULT_TOPIC_JNDI_LOCATION, (Object)AMQDestination.createDestination((String)this._qpidTopicExchange));
            }
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    public void uninitialize() {
        if (this._broker != null) {
            this._broker.shutdown();
        }
    }
}

