/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.test.mixins.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.environment.se.events.ContainerInitialized;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.junit.Assert;
import org.switchyard.ServiceDomain;
import org.switchyard.SwitchYardException;
import org.switchyard.common.type.Classes;
import org.switchyard.component.test.mixins.cdi.CDIMixInParticipant;
import org.switchyard.component.test.mixins.naming.NamingMixIn;
import org.switchyard.deploy.ServiceDomainManager;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.test.MixInDependencies;
import org.switchyard.test.SimpleTestDeployment;
import org.switchyard.test.TestMixIn;
import org.switchyard.test.mixins.AbstractTestMixIn;

@MixInDependencies(required={NamingMixIn.class})
public class CDIMixIn
extends AbstractTestMixIn {
    private static final String BINDING_CONTEXT = "java:comp";
    private static final String BEAN_MANAGER_NAME = "BeanManager";
    private static final Pattern[] RESOURCE_FILTER_PATTERNS = new Pattern[]{Pattern.compile(".*jbpm-.*-services.*beans\\.xml"), Pattern.compile(".*jbpm-runtime-manager.*beans\\.xml"), Pattern.compile(".*jbpm-human-task-.*beans\\.xml")};
    private Weld _weld;
    private WeldContainer _weldContainer;
    private AbstractDeployment _simpleCdiDeployment;

    public void initialize() {
        super.initialize();
        this._weld = new Weld(){

            protected Deployment createDeployment(final ResourceLoader resourceLoader, Bootstrap bootstrap) {
                ResourceLoader filterLoader = new ResourceLoader(){

                    public void cleanup() {
                        resourceLoader.cleanup();
                    }

                    public Class<?> classForName(String name) {
                        return resourceLoader.classForName(name);
                    }

                    public URL getResource(String name) {
                        return this.filter(resourceLoader.getResource(name));
                    }

                    public Collection<URL> getResources(String name) {
                        ArrayList<URL> urls = new ArrayList<URL>();
                        for (URL url : resourceLoader.getResources(name)) {
                            if ((url = this.filter(url)) == null) continue;
                            urls.add(url);
                        }
                        return urls;
                    }

                    private URL filter(URL url) {
                        if (url != null) {
                            for (Pattern pattern : RESOURCE_FILTER_PATTERNS) {
                                if (!pattern.matcher(url.toString()).matches()) continue;
                                return null;
                            }
                        }
                        return url;
                    }
                };
                Deployment deployment = super.createDeployment(filterLoader, bootstrap);
                if (CDIMixIn.this.getTestKit() != null) {
                    Set optionalDependencies = CDIMixIn.this.getTestKit().getOptionalDependencies((TestMixIn)CDIMixIn.this);
                    for (TestMixIn dependency : optionalDependencies) {
                        if (!(dependency instanceof CDIMixInParticipant)) continue;
                        try {
                            ((CDIMixInParticipant)dependency).participate(deployment);
                        }
                        catch (Exception e) {
                            throw new SwitchYardException("Can not initialize Weld due CDIMixIn initialization error", (Throwable)e);
                        }
                    }
                }
                return deployment;
            }
        };
        this._weldContainer = this._weld.initialize();
        this._weldContainer.event().select(ContainerInitialized.class, new Annotation[0]).fire((Object)new ContainerInitialized());
        try {
            Context ctx = (Context)new InitialContext().lookup(BINDING_CONTEXT);
            ctx.rebind(BEAN_MANAGER_NAME, (Object)this.getBeanManager());
        }
        catch (NamingException e) {
            e.printStackTrace();
            Assert.fail((String)"Failed to bind BeanManager into 'java:comp'.");
        }
    }

    public void before(AbstractDeployment deployment) {
        if (deployment instanceof SimpleTestDeployment) {
            Class simpleCdiDeploymentType = Classes.forName((String)"org.switchyard.component.bean.internal.SimpleCDIDeployment", ((Object)((Object)this)).getClass());
            if (simpleCdiDeploymentType == null) {
                Assert.fail((String)"Failed to locate the SimpleCDIDeployment class on the classpath.  Module must include the SwitchYard Bean Component as one of its depedencies.");
            }
            try {
                this._simpleCdiDeployment = (AbstractDeployment)simpleCdiDeploymentType.newInstance();
                this._simpleCdiDeployment.setParentDeployment(deployment);
                ServiceDomain domain = new ServiceDomainManager().createDomain();
                this._simpleCdiDeployment.init(domain, this.getTestKit().getActivators());
                this._simpleCdiDeployment.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to manually deploy Bean Service.  Exception: " + e.getMessage()));
            }
        }
    }

    public BeanManager getBeanManager() {
        return this._weldContainer.getBeanManager();
    }

    public Bean<?> getBean(String name) {
        BeanManager beanManager = this.getBeanManager();
        Set beans = beanManager.getBeans(name);
        if (beans != null && !beans.isEmpty()) {
            return (Bean)beans.iterator().next();
        }
        throw new IllegalStateException("Unable to find CDI bean @Named '" + name + "'.  \n\t - Check for a typo in the name. \n\t - Make sure the Class is annotated with the @Name annotation.");
    }

    public Bean getBean(Class<?> type) {
        BeanManager beanManager = this.getBeanManager();
        Set beans = beanManager.getBeans(type, new Annotation[0]);
        if (beans != null && !beans.isEmpty()) {
            return (Bean)beans.iterator().next();
        }
        throw new IllegalStateException("Unable to find CDI bean of type '" + type.getName() + "'.");
    }

    public Object getObject(String name) {
        return this.createBeanInstance(this.getBean(name));
    }

    public <T> T getObject(String name, Class<T> type) {
        return type.cast(this.getObject(name));
    }

    public <T> T getObject(Class<T> type) {
        return type.cast(this.createBeanInstance(this.getBean(type)));
    }

    public void after(AbstractDeployment deployment) {
        if (this._simpleCdiDeployment != null) {
            this._simpleCdiDeployment.stop();
            this._simpleCdiDeployment.destroy();
        }
    }

    public synchronized void uninitialize() {
        if (this._weld != null) {
            this._weld.shutdown();
            this._weld = null;
        } else {
            Thread.dumpStack();
        }
        super.uninitialize();
    }

    private Object createBeanInstance(Bean<?> bean) {
        BeanManager beanManager = this.getBeanManager();
        CreationalContext creationalContext = beanManager.createCreationalContext(null);
        return beanManager.getReference(bean, (Type)bean.getBeanClass(), creationalContext);
    }
}

