/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.test.mixins.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.switchyard.test.SwitchYardTestKit;
import org.switchyard.test.mixins.AbstractTestMixIn;

public class HTTPMixIn
extends AbstractTestMixIn {
    private static Logger _logger = Logger.getLogger(HTTPMixIn.class);
    public static final String HTTP_DELETE = "DELETE";
    public static final String HTTP_GET = "GET";
    public static final String HTTP_HEAD = "HEAD";
    public static final String HTTP_POST = "POST";
    public static final String HTTP_PUT = "PUT";
    public static final String HTTP_OPTIONS = "OPTIONS";
    private HttpClient _httpClient;
    private String _contentType = "text/xml";
    private HashMap<String, String> _requestHeaders = new HashMap();
    private HashMap<String, String> _expectedHeaders = new HashMap();
    private boolean _dumpMessages = false;

    public HTTPMixIn setContentType(String contentType) {
        this._contentType = contentType;
        return this;
    }

    public void initialize() {
        this._httpClient = new DefaultHttpClient();
    }

    public int sendStringAndGetStatus(String endpointURL, String request, String method) {
        HttpResponse httpResponse = this.sendStringAndGetMethod(endpointURL, request, method);
        int status = httpResponse.getStatusLine().getStatusCode();
        if (httpResponse.getEntity().getContentLength() == -1L) {
            this._httpClient.getConnectionManager().closeIdleConnections(0L, TimeUnit.SECONDS);
        } else {
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        }
        return status;
    }

    public String sendString(String endpointURL, String request, String method) {
        String response = null;
        try {
            HttpResponse httpResponse = this.sendStringAndGetMethod(endpointURL, request, method);
            response = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        }
        catch (IOException ioe) {
            _logger.error((Object)"Unable to get response", (Throwable)ioe);
        }
        return response;
    }

    public HttpResponse sendStringAndGetMethod(String endpointURL, String request, String method) {
        if (this._dumpMessages) {
            _logger.info((Object)("Sending a " + method + " request to [" + endpointURL + "]"));
            _logger.info((Object)("Request body:[" + request + "]"));
        }
        Object httpMethod = null;
        HttpResponse response = null;
        try {
            if (method.equals(HTTP_PUT)) {
                httpMethod = new HttpPut(endpointURL);
                httpMethod.setEntity((HttpEntity)new StringEntity(request, this._contentType, "UTF-8"));
            } else if (method.equals(HTTP_POST)) {
                httpMethod = new HttpPost(endpointURL);
                ((HttpPost)httpMethod).setEntity((HttpEntity)new StringEntity(request, this._contentType, "UTF-8"));
            } else {
                httpMethod = method.equals(HTTP_DELETE) ? new HttpDelete(endpointURL) : (method.equals(HTTP_OPTIONS) ? new HttpOptions(endpointURL) : (method.equals(HTTP_HEAD) ? new HttpHead(endpointURL) : new HttpGet(endpointURL)));
            }
            response = this.execute((HttpRequestBase)httpMethod);
        }
        catch (UnsupportedEncodingException e) {
            _logger.error((Object)"Unable to set request entity", (Throwable)e);
        }
        return response;
    }

    public String postString(String endpointURL, String request) {
        if (this._dumpMessages) {
            _logger.info((Object)("Sending a POST request to [" + endpointURL + "]"));
            _logger.info((Object)("Request body:[" + request + "]"));
        }
        HttpPost postMethod = new HttpPost(endpointURL);
        try {
            postMethod.setEntity((HttpEntity)new StringEntity(request, this._contentType, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            _logger.error((Object)"Unable to set request entity", (Throwable)e);
        }
        HttpResponse httpResponse = this.execute((HttpRequestBase)postMethod);
        try {
            return EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        }
        catch (IOException ioe) {
            _logger.error((Object)"Unable to get response entity", (Throwable)ioe);
            return null;
        }
    }

    public String postFile(String endpointURL, String request) {
        FileEntity requestEntity = new FileEntity(new File(request), "text/xml; charset=utf-8");
        if (this._dumpMessages) {
            _logger.info((Object)("Sending a POST request to [" + endpointURL + "]"));
            ByteArrayOutputStream target = new ByteArrayOutputStream();
            try {
                requestEntity.writeTo((OutputStream)target);
                _logger.info((Object)("Request body:[" + target.toString() + "]"));
            }
            catch (IOException e) {
                _logger.error((Object)"Unable to write FileEntity to stream", (Throwable)e);
            }
        }
        HttpPost postMethod = new HttpPost(endpointURL);
        postMethod.setEntity((HttpEntity)requestEntity);
        HttpResponse httpResponse = this.execute((HttpRequestBase)postMethod);
        try {
            return EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        }
        catch (IOException ioe) {
            _logger.error((Object)"Unable to get response entity", (Throwable)ioe);
            return null;
        }
    }

    public String postStringAndTestXML(String endpointURL, String request, String expectedResponse) {
        String response = this.postString(endpointURL, request);
        SwitchYardTestKit.compareXMLToString((String)response, (String)expectedResponse);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse postResourceAndGetMethod(String endpointURL, String requestResource) {
        if (this._dumpMessages) {
            _logger.info((Object)("Sending a POST request to [" + endpointURL + "]"));
            InputStream input = this.getTestKit().getResourceAsStream(requestResource);
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            int l = 0;
            try {
                while ((l = input.read(data)) >= 0) {
                    tmp.write(data, 0, l);
                }
                _logger.info((Object)("Request body:[" + new String(tmp.toByteArray()) + "]"));
            }
            catch (IOException e) {
                _logger.error((Object)"Unexpected Exception while reading request resource", (Throwable)e);
            }
        }
        HttpPost postMethod = new HttpPost(endpointURL);
        InputStream requestStream = this.getTestKit().getResourceAsStream(requestResource);
        HttpResponse response = null;
        try {
            if (this._contentType != null) {
                ContentType contentType = null;
                contentType = this._contentType.contains("charset") ? ContentType.create((String)this._contentType) : ContentType.create((String)this._contentType, (String)"utf-8");
                postMethod.setEntity((HttpEntity)new InputStreamEntity(requestStream, (long)requestStream.available(), contentType));
            } else {
                postMethod.setEntity((HttpEntity)new InputStreamEntity(requestStream, (long)requestStream.available()));
            }
            response = this.execute((HttpRequestBase)postMethod);
        }
        catch (IOException ioe) {
            _logger.error((Object)"Unable to get response entity", (Throwable)ioe);
        }
        finally {
            try {
                requestStream.close();
            }
            catch (IOException e) {
                Assert.fail((String)"Unexpected exception closing HTTP request resource stream.");
            }
        }
        return response;
    }

    public String postResource(String endpointURL, String requestResource) {
        String response = null;
        try {
            HttpResponse httpResponse = this.postResourceAndGetMethod(endpointURL, requestResource);
            int status = httpResponse.getStatusLine().getStatusCode();
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Response returned status code " + status));
            }
            response = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        }
        catch (IOException ioe) {
            _logger.error((Object)"Unable to get response", (Throwable)ioe);
        }
        return response;
    }

    public String postResourceAndTestXML(String endpointURL, String requestResource, String expectedResponseResource) {
        String response = this.postResource(endpointURL, requestResource);
        this.getTestKit().compareXMLToResource(response, expectedResponseResource);
        return response;
    }

    public int postResourceAndGetStatus(String endpointURL, String requestResource) {
        HttpResponse httpResponse = this.postResourceAndGetMethod(endpointURL, requestResource);
        int status = httpResponse.getStatusLine().getStatusCode();
        if (httpResponse.getEntity().getContentLength() == -1L) {
            this._httpClient.getConnectionManager().closeIdleConnections(0L, TimeUnit.SECONDS);
        } else {
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        }
        return status;
    }

    public HttpResponse execute(HttpRequestBase method) {
        if (this._httpClient == null) {
            Assert.fail((String)"HTTPMixIn not initialized.  You must call the initialize() method before using this MixIn");
        }
        for (String key : this._requestHeaders.keySet()) {
            method.setHeader((Header)new BasicHeader(key, this._requestHeaders.get(key)));
        }
        if (this._dumpMessages) {
            for (Header header : method.getAllHeaders()) {
                _logger.info((Object)("Request header:[" + header.getName() + "=" + header.getValue() + "]"));
            }
        }
        HttpResponse response = null;
        try {
            response = this._httpClient.execute((HttpUriRequest)method);
        }
        catch (Exception e) {
            Assert.fail((String)("Exception invoking HTTP endpoint '" + method.getURI() + "': " + e.getMessage()));
        }
        if (this._dumpMessages) {
            for (Header header : response.getAllHeaders()) {
                _logger.info((Object)("Received response header:[" + header.getName() + "=" + header.getValue() + "]"));
            }
            _logger.info((Object)("Received response body:[" + response + "]"));
        }
        for (String key : this._expectedHeaders.keySet()) {
            Header actual = response.getFirstHeader(key);
            Assert.assertNotNull((String)("Checking response header:[" + key + "]"), (Object)actual);
            Assert.assertEquals((String)("Checking response header:[" + key + "]"), (Object)this._expectedHeaders.get(key), (Object)actual.getValue());
        }
        return response;
    }

    public HTTPMixIn setRequestHeader(String name, String value) {
        this._requestHeaders.put(name, value);
        return this;
    }

    public HTTPMixIn setRequestHeaders(Map<String, String> headers) {
        this._requestHeaders.clear();
        this._requestHeaders.putAll(headers);
        return this;
    }

    public HTTPMixIn setExpectedHeader(String name, String value) {
        this._expectedHeaders.put(name, value);
        return this;
    }

    public HTTPMixIn setExpectedHeaders(Map<String, String> headers) {
        this._expectedHeaders.clear();
        this._expectedHeaders.putAll(headers);
        return this;
    }

    public HTTPMixIn setDumpMessages(boolean dumpMessages) {
        this._dumpMessages = dumpMessages;
        return this;
    }

    public void uninitialize() {
        if (this._httpClient != null) {
            this._httpClient.getConnectionManager().closeIdleConnections(0L, TimeUnit.SECONDS);
            this._httpClient.getConnectionManager().shutdown();
        }
    }
}

