/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.test.mixins.jca;

import java.util.List;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;
import org.apache.log4j.Logger;
import org.switchyard.component.test.mixins.jca.InteractionListener;

public class MockInteraction
implements Interaction {
    private Logger _logger = Logger.getLogger(MockInteraction.class);
    private List<InteractionListener> _listener;

    public MockInteraction(List<InteractionListener> listener) {
        this._listener = listener;
    }

    public void close() throws ResourceException {
        this._logger.debug((Object)"call close()");
    }

    public Connection getConnection() {
        this._logger.debug((Object)"call getConnection()");
        return null;
    }

    public boolean execute(InteractionSpec ispec, Record input, Record output) throws ResourceException {
        this._logger.debug((Object)("call execute(" + ispec + ", " + input + ", " + output + ")"));
        boolean result = true;
        for (InteractionListener l : this._listener) {
            result &= l.onExecute(ispec, input, output);
        }
        return result;
    }

    public Record execute(InteractionSpec ispec, Record input) throws ResourceException {
        this._logger.debug((Object)("call execute(" + ispec + ", " + input + ")"));
        Record output = null;
        for (InteractionListener l : this._listener) {
            input = output = l.onExecute(ispec, input);
        }
        return output;
    }

    public ResourceWarning getWarnings() throws ResourceException {
        this._logger.debug((Object)"call getWarnings()");
        return null;
    }

    public void clearWarnings() throws ResourceException {
        this._logger.debug((Object)"call clearWarnings()");
    }
}

