/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.test.mixins.transaction;

import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionSynchronizationRegistryImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.UserTransactionImple;
import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.apache.log4j.Logger;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.switchyard.SwitchYardException;
import org.switchyard.component.test.mixins.cdi.CDIMixInParticipant;
import org.switchyard.component.test.mixins.naming.NamingMixIn;
import org.switchyard.component.test.mixins.transaction.LocalArjunaTransactionServices;
import org.switchyard.component.test.mixins.transaction.TransactionMixInParticipant;
import org.switchyard.test.MixInDependencies;
import org.switchyard.test.TestMixIn;
import org.switchyard.test.mixins.AbstractTestMixIn;

@MixInDependencies(required={NamingMixIn.class})
public class TransactionMixIn
extends AbstractTestMixIn
implements CDIMixInParticipant {
    private String _storeDir = "target/tx-store";
    private JTAEnvironmentBean _jtaEnvironmentBean;
    private Logger _logger = Logger.getLogger(TransactionMixIn.class);

    public void initialize() {
        if (this.getTestKit() != null) {
            Iterator mixins = this.getTestKit().getMixIns().iterator();
            while (this._jtaEnvironmentBean == null && mixins.hasNext()) {
                TestMixIn testMixIn = (TestMixIn)mixins.next();
                if (!(testMixIn instanceof TransactionMixInParticipant)) continue;
                try {
                    this._logger.debug((Object)("Trying to locate JTA environment using " + testMixIn));
                    this._jtaEnvironmentBean = ((TransactionMixInParticipant)testMixIn).locateEnvironmentBean();
                }
                catch (Throwable e) {
                    throw new SwitchYardException("Exception during locating arjuna environment bean", e);
                }
            }
        }
        try {
            if (this._jtaEnvironmentBean == null) {
                System.setProperty("ObjectStoreEnvironmentBean.objectStoreDir", this._storeDir);
                System.setProperty("com.arjuna.ats.arjuna.objectstore.objectStoreDir", this._storeDir);
                this._jtaEnvironmentBean = jtaPropertyManager.getJTAEnvironmentBean();
                this._jtaEnvironmentBean.setTransactionManagerClassName(TransactionManagerImple.class.getName());
                this._jtaEnvironmentBean.setUserTransactionClassName(UserTransactionImple.class.getName());
                this._jtaEnvironmentBean.setTransactionSynchronizationRegistryClassName(TransactionSynchronizationRegistryImple.class.getName());
                InitialContext initialContext = new InitialContext();
                initialContext.bind("java:jboss/TransactionManager", (Object)this._jtaEnvironmentBean.getTransactionManager());
                initialContext.bind("java:jboss/UserTransaction", (Object)this._jtaEnvironmentBean.getUserTransaction());
                initialContext.bind("java:jboss/TransactionSynchronizationRegistry", (Object)this._jtaEnvironmentBean.getTransactionSynchronizationRegistry());
            }
        }
        catch (NamingException e) {
            throw new SwitchYardException("Unable to bind transaction manager in JNDI", (Throwable)e);
        }
    }

    public UserTransaction getUserTransaction() {
        return this._jtaEnvironmentBean.getUserTransaction();
    }

    public TransactionManager getTransactionManager() {
        return this._jtaEnvironmentBean.getTransactionManager();
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return this._jtaEnvironmentBean.getTransactionSynchronizationRegistry();
    }

    public JTAEnvironmentBean getEnvironmentBean() {
        return this._jtaEnvironmentBean;
    }

    public void participate(Deployment deployment) throws Exception {
        deployment.getServices().add(TransactionServices.class, (Service)new LocalArjunaTransactionServices(this._jtaEnvironmentBean));
    }
}

