/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.test.mixins.smooks;

import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.switchyard.config.model.transform.TransformModel;
import org.switchyard.test.mixins.AbstractTestMixIn;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.config.model.SmooksTransformType;
import org.switchyard.transform.config.model.TransformNamespace;
import org.switchyard.transform.config.model.v1.V1SmooksTransformModel;

public class SmooksMixIn
extends AbstractTestMixIn {
    private boolean _dumpResultsToSysout = false;

    public void dumpResultsToSysout(boolean dumpResultsToSysout) {
        this._dumpResultsToSysout = dumpResultsToSysout;
    }

    public void testJavaXMLReadWrite(Class<?> javaType, String bindingConfigResPath, String xmlResPath) {
        Transformer xml2JavaTransformer = this.newTransformer(bindingConfigResPath, SmooksTransformType.XML2JAVA);
        Transformer java2xmlTransformer = this.newTransformer(bindingConfigResPath, SmooksTransformType.JAVA2XML);
        String xml = this.getTestKit().readResourceString(xmlResPath);
        Object javaObject = xml2JavaTransformer.transform((Object)xml);
        Assert.assertNotNull((String)"XML to Java transformation failed.  null object returned.", (Object)javaObject);
        Assert.assertTrue((String)("XML to Java transformation failed.  Wrong type returned.  Expected '" + javaType.getName() + "' but got '" + javaObject.getClass().getName() + "'."), (boolean)javaType.isInstance(javaObject));
        if (this._dumpResultsToSysout) {
            System.out.println("------------XML to Java Result:\n" + javaObject);
            System.out.println("-------------------------------");
        }
        String xmlResult = (String)java2xmlTransformer.transform(javaObject);
        Assert.assertNotNull((String)"Java to XML transformation failed.  null object returned.", (Object)javaObject);
        if (this._dumpResultsToSysout) {
            System.out.println("------------Java to XML Result:\n" + xmlResult);
            System.out.println("-------------------------------");
        }
        XMLUnit.setIgnoreWhitespace((boolean)true);
        try {
            XMLAssert.assertXMLEqual((String)xml, (String)xmlResult);
        }
        catch (Exception e) {
            Assert.fail((String)"Unexpected error performing XML comparison.");
        }
    }

    public Transformer newTransformer(String smooksConfigResPath, SmooksTransformType transformerType) {
        TransformModel transformModel = new V1SmooksTransformModel(TransformNamespace.DEFAULT.uri()).setConfig(smooksConfigResPath).setTransformType(transformerType).setFrom(new QName("from")).setTo(new QName("to"));
        return this.getTestKit().newTransformer(transformModel);
    }
}

