/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.karaf;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.switchyard.admin.Application;
import org.switchyard.admin.Service;
import org.switchyard.admin.SwitchYard;
import org.switchyard.deploy.karaf.AbstractSwitchYardServiceCommand;

@Command(scope="switchyard", name="list-services", description="Returns a list of SwitchYard services used by application(s) deployed on the system.")
public class ListServicesCommand
extends AbstractSwitchYardServiceCommand {
    @Argument(index=0, name="application", description="If specified, only services for the named application are returned.", multiValued=true)
    private List<String> _applicationNames;
    @Option(name="--regex", description="If specified, treat the application name(s) as a regular expression.")
    private boolean _regex;

    @Override
    protected Object doExecute(SwitchYard switchYard) throws Exception {
        Pattern pattern = this.compilePattern(this._applicationNames, this._regex);
        for (Application application : switchYard.getApplications()) {
            String applicationName = String.valueOf(application.getName());
            Matcher matcher = pattern.matcher(applicationName);
            if (!matcher.find()) continue;
            System.out.println(String.format("  SwitchYard References: %s  ", applicationName));
            for (Service service : application.getServices()) {
                System.out.println(String.format("[ %s ]", service.getName()));
            }
        }
        return null;
    }
}

