/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.karaf;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.switchyard.admin.Application;
import org.switchyard.admin.Service;
import org.switchyard.admin.SwitchYard;
import org.switchyard.deploy.karaf.AbstractSwitchYardServiceCommand;
import org.switchyard.deploy.karaf.PrintUtil;

@Command(scope="switchyard", name="read-service", description="Returns a details about a SwitchYard service deployed on the system.")
public class ReadServiceCommand
extends AbstractSwitchYardServiceCommand {
    @Option(name="--application", aliases={"-a"}, description="If specified, only details for the named application are returned.", multiValued=true)
    private List<String> _applicationNames;
    @Option(name="--service", aliases={"-s"}, description="If specified, only details for the named service are returned.", multiValued=true)
    private List<String> _serviceNames;
    @Option(name="--regex", description="If specified, treat the name(s) as a regular expression.")
    private boolean _regex;

    @Override
    protected Object doExecute(SwitchYard switchYard) throws Exception {
        Pattern applicationPattern = this.compilePattern(this._applicationNames, this._regex);
        Pattern servicePattern = this.compilePattern(this._serviceNames, this._regex);
        for (Application application : switchYard.getApplications()) {
            String applicationName = application.getName().toString();
            Matcher applicationMatcher = applicationPattern.matcher(applicationName);
            if (!applicationMatcher.find()) continue;
            System.out.println(application.getName() + " = [");
            for (Service service : application.getServices()) {
                String serviceName = service.getName().toString();
                Matcher serviceMatcher = servicePattern.matcher(serviceName);
                if (!serviceMatcher.find()) continue;
                System.out.println(PrintUtil.printService(service, 1));
            }
            System.out.println("]");
        }
        return null;
    }
}

