/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demo.cluster;

import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.quickstarts.demo.cluster.Application;
import org.switchyard.quickstarts.demo.cluster.CreditCheck;
import org.switchyard.quickstarts.demo.cluster.Deal;
import org.switchyard.quickstarts.demo.cluster.Dealer;
import org.switchyard.quickstarts.demo.cluster.Offer;

@Service(value=Dealer.class)
public class DealerBean
implements Dealer {
    private Logger _log = Logger.getLogger(DealerBean.class);
    @Inject
    @Reference
    private CreditCheck creditService;

    @Override
    public Deal offer(Offer offer) {
        this._log.info((Object)"Dealer Service : Received an offer");
        Deal deal = new Deal();
        deal.setOffer(offer);
        if (offer.getCar().getPrice() * 0.9 > offer.getAmount()) {
            deal.setAccepted(false);
            return deal;
        }
        this._log.info((Object)"Dealer Service : Checking Credit");
        Application creditReply = this.creditService.checkCredit(offer);
        deal.setAccepted(creditReply.isApproved());
        return deal;
    }
}

