/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demo.policy.security.saml;

import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.annotations.Requires;
import org.switchyard.component.bean.Service;
import org.switchyard.policy.SecurityPolicy;
import org.switchyard.quickstarts.demo.policy.security.saml.Work;
import org.switchyard.quickstarts.demo.policy.security.saml.WorkAck;
import org.switchyard.quickstarts.demo.policy.security.saml.WorkService;

@Requires(security={SecurityPolicy.CONFIDENTIALITY, SecurityPolicy.CLIENT_AUTHENTICATION})
@Service(value=WorkService.class)
public class WorkServiceBean
implements WorkService {
    private static final Logger LOGGER = Logger.getLogger(WorkServiceBean.class);
    private static final String MSG = ":: WorkService :: Received work command => %s (caller principal=%s)";
    @Inject
    private Exchange exchange;

    @Override
    public WorkAck doWork(Work work) {
        String cmd = work.getCommand();
        String msg = String.format(MSG, cmd, this.exchange.getSecurity().getCallerPrincipal());
        LOGGER.info((Object)msg);
        return new WorkAck().setCommand(cmd).setReceived(true);
    }
}

