/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demo.policy.transaction;

import javax.inject.Inject;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.quickstarts.demo.policy.transaction.TaskAService;
import org.switchyard.quickstarts.demo.policy.transaction.TaskBService;
import org.switchyard.quickstarts.demo.policy.transaction.TaskCService;
import org.switchyard.quickstarts.demo.policy.transaction.WorkService;
import org.switchyard.runtime.util.TransactionManagerLocator;

@Service(value=WorkService.class)
public class WorkServiceBean
implements WorkService {
    public static final String ROLLBACK = "rollback";
    @Inject
    @Reference
    private TaskAService _taskAService;
    @Inject
    @Reference
    private TaskBService _taskBService;
    @Inject
    @Reference
    private TaskCService _taskCService;

    @Override
    public final void doWork(String command) {
        this.print("Received command =>  " + command);
        Transaction t = null;
        try {
            t = this.getCurrentTransaction();
        }
        catch (Exception e) {
            this.print("Failed to get current transcation");
            return;
        }
        if (t == null) {
            this.print("No active transaction");
        }
        this._taskAService.doTask(command);
        this._taskBService.doTask(command);
        this._taskCService.doTask(command);
        try {
            t = this.getCurrentTransaction();
            if (t == null) {
                this.print("No active transaction");
                return;
            }
            if (t.getStatus() == 1) {
                this.print("transaction is marked as rollback only");
            } else if (t.getStatus() == 0) {
                this.print("transaction will be committed");
            } else {
                this.print("Invalid transaction status: " + t.getStatus());
            }
        }
        catch (Exception e) {
            this.print("Failed to get current transaction status");
        }
    }

    private Transaction getCurrentTransaction() throws Exception {
        TransactionManager tm = TransactionManagerLocator.locateTransactionManager();
        return tm.getTransaction();
    }

    private void print(String message) {
        System.out.println(":: WorkService :: " + message);
    }
}

