/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demo.security.propagation.basic;

import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeSecurity;
import org.switchyard.annotations.Requires;
import org.switchyard.component.bean.Service;
import org.switchyard.policy.SecurityPolicy;
import org.switchyard.quickstarts.demo.security.propagation.basic.BackEndService;

@Requires(security={SecurityPolicy.CONFIDENTIALITY, SecurityPolicy.CLIENT_AUTHENTICATION, SecurityPolicy.AUTHORIZATION})
@Service(value=BackEndService.class)
public class BackEndServiceBean
implements BackEndService {
    private static final Logger LOGGER = Logger.getLogger(BackEndServiceBean.class);
    private static final String MSG = ":: BackEndService :: process => %s (caller principal=%s, in roles? 'friend'=%s 'enemy'=%s)";
    @Inject
    private Exchange exchange;

    @Override
    public String process(String in) {
        ExchangeSecurity es = this.exchange.getSecurity();
        String msg = String.format(MSG, in, es.getCallerPrincipal(), es.isCallerInRole("friend"), es.isCallerInRole("enemy"));
        LOGGER.info((Object)msg);
        return "Processed by BackEndService: " + in;
    }
}

