/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demo.security.propagation.ejb;

import javax.annotation.Resource;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.switchyard.quickstarts.demo.security.propagation.ejb.TestEJBBeanLocal;

@Stateless
@EJB(name="java:global/TestEJBBean", beanInterface=TestEJBBeanLocal.class)
@RolesAllowed(value={"friend"})
@SecurityDomain(value="other")
public class TestEJBBean
implements TestEJBBeanLocal {
    private static final Logger LOGGER = Logger.getLogger(TestEJBBean.class);
    private static final String MSG_1 = ":: TestEJBBean :: process => %s (caller principal=%s, in roles? 'friend'=%s 'enemy'=%s)";
    @Resource
    private SessionContext ctx;

    @Override
    public String process(String in) {
        String msg1 = String.format(MSG_1, in, this.ctx.getCallerPrincipal(), this.ctx.isCallerInRole("friend"), this.ctx.isCallerInRole("enemy"));
        LOGGER.info((Object)msg1);
        return "Processed by TestEJBBean: " + in;
    }
}

