/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demo.txpropagation;

import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.quickstarts.demo.txpropagation.Application;
import org.switchyard.quickstarts.demo.txpropagation.CreditCheckService;
import org.switchyard.quickstarts.demo.txpropagation.Deal;
import org.switchyard.quickstarts.demo.txpropagation.DealLogger;
import org.switchyard.quickstarts.demo.txpropagation.Dealer;
import org.switchyard.quickstarts.demo.txpropagation.Offer;

@Service(value=Dealer.class)
public class DealerBean
implements Dealer {
    @Inject
    @Reference
    private CreditCheckService creditService;
    @Inject
    @Reference
    private DealLogger dealLogger;

    @Override
    public Deal offer(Offer offer) {
        System.out.println("Dealer Service : Received an offer");
        Deal deal = new Deal();
        deal.setOffer(offer);
        if (offer.getCar().getPrice() * 0.9 > offer.getAmount()) {
            deal.setAccepted(false);
            return deal;
        }
        System.out.println("Dealer Service : Checking Credit");
        Application creditReply = this.creditService.checkCredit(offer);
        offer.getApplication().setApproved(creditReply.isApproved());
        deal.setAccepted(creditReply.isApproved());
        if (!deal.isAccepted()) {
            try {
                UserTransaction tx = (UserTransaction)new InitialContext().lookup("java:jboss/UserTransaction");
                tx.setRollbackOnly();
                System.out.println("Dealer Service : Low credit score - transaction has been rolled back");
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to rollback transaction", e);
            }
        } else {
            this.dealLogger.store(deal);
        }
        return deal;
    }
}

