/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demos.helpdesk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import org.apache.log4j.Logger;
import org.switchyard.component.bpm.task.service.Task;
import org.switchyard.component.bpm.task.service.TaskClient;
import org.switchyard.component.bpm.task.service.TaskContent;
import org.switchyard.component.bpm.task.service.TaskService;
import org.switchyard.quickstarts.demos.helpdesk.Ticket;

@ManagedBean(name="helpDesk")
@SessionScoped
public class HelpDesk {
    private static final Logger LOGGER = Logger.getLogger(HelpDesk.class);
    private static final String TICKET = "ticket";
    private static final Map<String, List<String>> USERS_GROUPS = new LinkedHashMap();
    private final TaskClient _taskClient = TaskService.instance().newTaskClient();
    private final List<Task> _userTasks = Collections.synchronizedList(new ArrayList());
    private final Map<Long, Ticket> _userTickets = Collections.synchronizedMap(new LinkedHashMap());
    private String _userId;

    public String getUserId() {
        return this._userId;
    }

    public void setUserId(String userId) {
        this._userId = userId;
    }

    public String getGroupId() {
        List groups = (List)USERS_GROUPS.get(this._userId);
        return groups != null && groups.size() > 0 ? (String)groups.get(0) : null;
    }

    public Map<String, String> getUsersGroups() {
        LinkedHashMap<String, String> usersGroups = new LinkedHashMap<String, String>();
        for (Map.Entry entry : USERS_GROUPS.entrySet()) {
            String key = (String)entry.getKey();
            usersGroups.put(key + " (" + (String)((List)entry.getValue()).get(0) + ")", key);
        }
        return usersGroups;
    }

    public List<Task> getUserTasks() {
        return this._userTasks;
    }

    public Map<Long, Ticket> getUserTickets() {
        return this._userTickets;
    }

    public void selectUser(ValueChangeEvent vce) {
        this.setUserId((String)vce.getNewValue());
        this.fetchTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchTasks() {
        List list = this._userTasks;
        synchronized (list) {
            this._userTasks.clear();
            this._userTickets.clear();
            try {
                this._taskClient.connect();
                List tasks = this._taskClient.getTasksAssignedAsPotentialOwner(this._userId, (List)USERS_GROUPS.get(this._userId));
                for (Task task : tasks) {
                    this._userTasks.add(task);
                    TaskContent taskContent = this._taskClient.getTaskContent(task.getTaskContentId());
                    Map params = taskContent.getMap();
                    Ticket ticket = (Ticket)params.get(TICKET);
                    this._userTickets.put(task.getProcessInstanceId(), ticket);
                }
            }
            finally {
                this._taskClient.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeTasks() {
        List list = this._userTasks;
        synchronized (list) {
            if (this._userTasks.size() > 0) {
                try {
                    this._taskClient.connect();
                    for (Task task : this._userTasks) {
                        this._taskClient.claim(task.getId(), this._userId, (List)USERS_GROUPS.get(this._userId));
                        this._taskClient.start(task.getId(), this._userId);
                        TaskContent taskContent = this._taskClient.getTaskContent(task.getTaskContentId());
                        Map results = taskContent.getMap();
                        Ticket ticket = (Ticket)this._userTickets.get(task.getProcessInstanceId());
                        results.put(TICKET, ticket);
                        this._taskClient.complete(task.getId(), this._userId, taskContent);
                    }
                }
                finally {
                    this._taskClient.disconnect();
                }
            }
        }
    }

    public void submit() {
        try {
            this.completeTasks();
            this.fetchTasks();
        }
        catch (Throwable t) {
            StringBuilder sb = new StringBuilder();
            sb.append("Problem processing tasks: ");
            sb.append(t.getClass().getName());
            String m = t.getMessage();
            if (m != null) {
                sb.append("(");
                sb.append(m);
                sb.append(")");
            }
            String msg = sb.toString();
            LOGGER.error((Object)msg, t);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(msg));
        }
    }

    static {
        USERS_GROUPS.put("krisv", Arrays.asList("developers"));
        USERS_GROUPS.put("david", Arrays.asList("users"));
    }
}

