/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demo.policy.transaction;

import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.switchyard.annotations.ManagedTransaction;
import org.switchyard.annotations.ManagedTransactionType;
import org.switchyard.component.bean.Service;
import org.switchyard.quickstarts.demo.policy.transaction.WorkService;

@Service(value=WorkService.class)
@ManagedTransaction(value=ManagedTransactionType.SHARED)
public class WorkServiceBean
implements WorkService {
    public static final String ROLLBACK = "rollback";
    private static final String JNDI_TRANSACTION_MANAGER = "java:jboss/TransactionManager";
    private int rollbackCounter = 0;

    @Override
    public final void doWork(String command) {
        this.print("Received command =>  " + command);
        if (command.contains(ROLLBACK)) {
            try {
                Transaction t = this.getCurrentTransaction();
                if (t == null) {
                    this.print("No active transaction to rollback.");
                } else if (++this.rollbackCounter % 4 != 0) {
                    t.setRollbackOnly();
                    this.print("Marked transaction to rollback!");
                } else {
                    this.print("Rollbacks completed");
                }
            }
            catch (Exception ex) {
                this.print("Failed to rollback transaction: " + ex.toString());
            }
        }
    }

    private Transaction getCurrentTransaction() throws Exception {
        TransactionManager tm = (TransactionManager)new InitialContext().lookup(JNDI_TRANSACTION_MANAGER);
        return tm.getTransaction();
    }

    private void print(String message) {
        System.out.println(":: WorkService :: " + message);
    }
}

