/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.camel.hl7example;

import ca.uhn.hl7v2.model.v24.message.QRY_A19;
import ca.uhn.hl7v2.model.v24.segment.QRD;
import ca.uhn.hl7v2.parser.PipeParser;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.hl7.HL7DataFormat;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.switchyard.common.camel.SwitchYardMessage;

public class CamelServiceRoute
extends RouteBuilder {
    public void configure() {
        HL7DataFormat hl7 = new HL7DataFormat();
        ((RouteDefinition)this.from("switchyard://HL7Route").unmarshal((DataFormat)hl7)).process(new Processor(){

            public void process(Exchange exchange) throws Exception {
                String body = (String)exchange.getIn().getBody(String.class);
                PipeParser pipeParser = new PipeParser();
                ca.uhn.hl7v2.model.Message message = pipeParser.parse(body);
                if (message instanceof QRY_A19) {
                    QRD qrd = (QRD)message.get("QRD");
                    System.out.println("Query Date/Time : " + qrd.getQueryDateTime().getTimeOfAnEvent().getValue());
                    System.out.println("Query Format Code : " + qrd.getQueryFormatCode().getValue());
                    System.out.println("Query Priority : " + qrd.getQueryPriority().getValue());
                    System.out.println("Query ID : " + qrd.getQueryID().getValue());
                    System.out.println("Deferred Response Type : " + qrd.getDeferredResponseType().getValue());
                    System.out.println("Deferred Response Date/Time : " + qrd.getDeferredResponseDateTime().getTimeOfAnEvent().getValue());
                    System.out.println("Quantity Limited Request : " + qrd.getQuantityLimitedRequest().getQuantity().getValue());
                    System.out.println("Query Results Level : " + qrd.getQueryResultsLevel().getValue());
                    qrd.getQueryID();
                }
                SwitchYardMessage out = new SwitchYardMessage();
                out.setBody((Object)body);
                exchange.setOut((Message)out);
            }
        });
    }
}

