/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.camel.netty.binding;

import java.io.File;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Named;

@ApplicationScoped
public class SslConfigurationFactory {
    private static final String JBOSS_HOME = System.getenv("JBOSS_HOME");

    @Produces
    @Named(value="password")
    public String password() {
        return "changeit";
    }

    @Produces
    @Named(value="trustStore")
    public File trustStore() {
        return new File(this.getPath("users.jks"));
    }

    @Produces
    @Named(value="keyStore")
    public File keyStore() {
        return new File(this.getPath("users.jks"));
    }

    private String getPath(String fileName) {
        if (JBOSS_HOME != null) {
            return JBOSS_HOME + "/quickstarts/camel-netty-binding/" + fileName;
        }
        return fileName;
    }
}

