/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.camel.netty.binding;

import java.io.File;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Named;

@ApplicationScoped
public class SslConfigurationFactory {
    private static final String JBOSS_HOME = System.getenv("JBOSS_HOME");
    private static final String KARAF_HOME = System.getProperty("karaf.home");

    @Produces
    @Named(value="password")
    public String password() {
        return "changeit";
    }

    @Produces
    @Named(value="trustStore")
    public File trustStore() {
        return new File(this.getPath("users.jks"));
    }

    @Produces
    @Named(value="keyStore")
    public File keyStore() {
        return new File(this.getPath("users.jks"));
    }

    private String getPath(String fileName) {
        String fileHome = null;
        if (JBOSS_HOME != null) {
            fileHome = JBOSS_HOME;
        } else if (KARAF_HOME != null) {
            fileHome = KARAF_HOME;
        }
        if (fileHome != null) {
            return fileHome + "/quickstarts/camel-netty-binding/" + fileName;
        }
        return fileName;
    }
}

