/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.camel.sap.binding;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.switchyard.component.bean.Service;
import org.switchyard.quickstarts.camel.sap.binding.PassengerInfoService;
import org.switchyard.quickstarts.camel.sap.binding.bean.PassengerInfo;
import org.switchyard.quickstarts.camel.sap.binding.jaxb.BookFlightRequest;

@Service(value=PassengerInfoService.class)
public class PassengerInfoServiceBean
implements PassengerInfoService {
    private static final Logger LOG = LoggerFactory.getLogger(PassengerInfoServiceBean.class);

    @Override
    public PassengerInfo getPassengerInfo(BookFlightRequest request) {
        Date passengerDateOfBirth;
        String passengerName;
        PassengerInfo passengerInfo = new PassengerInfo();
        String passengerFormOfAddress = request.getPassengerFormOfAddress();
        if (passengerFormOfAddress != null) {
            passengerInfo.setFormOfAddress(passengerFormOfAddress);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set passenger form of address = '{}' in passenger info", (Object)passengerFormOfAddress);
            }
        }
        if ((passengerName = request.getPassengerName()) != null) {
            passengerInfo.setName(passengerName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set passenger name = '{}' in passenger info", (Object)passengerName);
            }
        }
        if ((passengerDateOfBirth = request.getPassengerDateOfBirth()) != null) {
            passengerInfo.setDateOfBirth(passengerDateOfBirth);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set passenger date of birth = '{}' in passenger info", (Object)passengerDateOfBirth);
            }
        }
        return passengerInfo;
    }
}

