/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.camel.sql.binding;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.Converter;
import org.apache.log4j.Logger;
import org.switchyard.quickstarts.camel.sql.binding.Greeting;
import org.switchyard.quickstarts.camel.sql.binding.PojoIterator;

@Converter
public class GreetingConverter {
    private static final Logger LOGGER = Logger.getLogger(GreetingConverter.class);

    @Converter
    public static Iterator<Object> from(Greeting greeting) {
        return new PojoIterator(greeting);
    }

    @Converter
    public static Greeting[] from(List<Map<String, Object>> objects) {
        Greeting[] greetings = new Greeting[objects.size()];
        int position = 0;
        for (Map<String, Object> greeting : objects) {
            greetings[position++] = new Greeting((Integer)greeting.get("id"), (String)greeting.get("receiver"), (String)greeting.get("sender"));
        }
        return greetings;
    }

    @Converter
    public static Greeting from(Map<String, Object> object) {
        LOGGER.debug((Object)("Converting " + object.toString() + "to a Greeting object"));
        Greeting greeting = new Greeting((Integer)object.get("id"), (String)object.get("receiver"), (String)object.get("sender"));
        return greeting;
    }
}

